/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.OperationAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.RowCell;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.protobuf.BigtableZeroCopyByteStringUtil;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;

public class PutAdapter
implements OperationAdapter<Put, MutateRowRequest.Builder> {
    private final int maxKeyValueSize;
    private final boolean setClientTimestamp;

    public PutAdapter(int maxKeyValueSize) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = true;
    }

    public PutAdapter(int maxKeyValueSize, boolean setClientTimestamp) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = setClientTimestamp;
    }

    @Override
    public MutateRowRequest.Builder adapt(Put operation) {
        if (operation.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        MutateRowRequest.Builder result = MutateRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom(operation.getRow()));
        long currentTimestampMicros = this.setClientTimestamp ? System.currentTimeMillis() * 1000L : -1L;
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            ByteString familyString = ByteString.copyFrom((byte[])entry.getKey());
            for (Cell cell : (List)entry.getValue()) {
                int keyValueSize = 20 + cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + cell.getValueLength();
                if (this.maxKeyValueSize > 0 && keyValueSize > this.maxKeyValueSize) {
                    throw new IllegalArgumentException("KeyValue size too large");
                }
                Mutation.Builder modBuilder = result.addMutationsBuilder();
                Mutation.SetCell.Builder setCellBuilder = modBuilder.getSetCellBuilder();
                ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                setCellBuilder.setFamilyNameBytes(familyString);
                setCellBuilder.setColumnQualifier(cellQualifierByteString);
                if (cell.getTimestamp() != Long.MAX_VALUE) {
                    long timestampMicros = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp(), BigtableConstants.HBASE_TIMEUNIT);
                    setCellBuilder.setTimestampMicros(timestampMicros);
                } else {
                    setCellBuilder.setTimestampMicros(currentTimestampMicros);
                }
                setCellBuilder.setValue(ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            }
        }
        return result;
    }

    @Override
    public Put adapt(MutateRowRequest request) throws IOException {
        if (request.getMutationsCount() == 0) {
            throw new IllegalArgumentException("No columns to insert");
        }
        byte[] rowkeyArray = request.getRowKey().toByteArray();
        Put put = new Put(rowkeyArray);
        for (Mutation mutation : request.getMutationsList()) {
            if (mutation.getMutationCase() != Mutation.MutationCase.SET_CELL) {
                throw new IllegalArgumentException("Cannot process mutation of type: " + mutation.getMutationCase());
            }
            Mutation.SetCell setCell = mutation.getSetCell();
            long timestampHbase = setCell.getTimestampMicros() == -1L ? Long.MAX_VALUE : BigtableConstants.HBASE_TIMEUNIT.convert(setCell.getTimestampMicros(), BigtableConstants.BIGTABLE_TIMEUNIT);
            put.add((Cell)new RowCell(rowkeyArray, PutAdapter.getBytes(setCell.getFamilyNameBytes()), PutAdapter.getBytes(setCell.getColumnQualifier()), timestampHbase, PutAdapter.getBytes(setCell.getValue())));
        }
        return put;
    }

    private static byte[] getBytes(ByteString bs) {
        return BigtableZeroCopyByteStringUtil.zeroCopyGetBytes(bs);
    }
}

