/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.admin;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.admin.ColumnDescriptorAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.admin.v2.Table;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;

public class TableAdapter {
    private final BigtableInstanceName bigtableInstanceName;
    private final ColumnDescriptorAdapter columnDescriptorAdapter;

    public TableAdapter(BigtableOptions options, ColumnDescriptorAdapter columnDescriptorAdapter) {
        this.bigtableInstanceName = options.getInstanceName();
        this.columnDescriptorAdapter = columnDescriptorAdapter;
    }

    public Table adapt(HTableDescriptor desc) {
        Table.Builder tableBuilder = Table.newBuilder();
        Map<String, ColumnFamily> columnFamilies = tableBuilder.getMutableColumnFamilies();
        for (HColumnDescriptor column : desc.getColumnFamilies()) {
            ColumnFamily columnFamily = this.columnDescriptorAdapter.adapt(column).build();
            String columnName = column.getNameAsString();
            columnFamilies.put(columnName, columnFamily);
        }
        return tableBuilder.build();
    }

    public HTableDescriptor adapt(Table table) {
        String tableId = this.bigtableInstanceName.toTableId(table.getName());
        HTableDescriptor tableDescriptor = new HTableDescriptor(TableName.valueOf((String)tableId));
        for (Map.Entry<String, ColumnFamily> entry : table.getColumnFamilies().entrySet()) {
            tableDescriptor.addFamily(this.columnDescriptorAdapter.adapt(entry.getKey(), entry.getValue()));
        }
        return tableDescriptor;
    }
}

