/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.client.util.Throwables;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.ResponseAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Cell;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Column;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Family;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;

public class BigtableWhileMatchResultScannerAdapter {
    private static final String WHILE_MATCH_FILTER_IN_LABEL_SUFFIX = "-in";
    private static final String WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX = "-out";
    final ResponseAdapter<Row, Result> rowAdapter;

    public BigtableWhileMatchResultScannerAdapter(ResponseAdapter<Row, Result> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public org.apache.hadoop.hbase.client.ResultScanner adapt(final ResultScanner<Row> bigtableResultScanner) {
        return new AbstractClientScanner(){

            public Result next() throws IOException {
                Row row = (Row)bigtableResultScanner.next();
                if (row == null) {
                    return null;
                }
                if (!BigtableWhileMatchResultScannerAdapter.hasMatchingLabels(row)) {
                    return null;
                }
                return BigtableWhileMatchResultScannerAdapter.this.rowAdapter.adaptResponse(row);
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (IOException ioe) {
                    throw Throwables.propagate(ioe);
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }

    private static boolean hasMatchingLabels(Row row) {
        int inLabelCount = 0;
        int outLabelCount = 0;
        for (Family family : row.getFamiliesList()) {
            for (Column column : family.getColumnsList()) {
                for (Cell cell : column.getCellsList()) {
                    for (String label : cell.getLabelsList()) {
                        if (label.endsWith(WHILE_MATCH_FILTER_IN_LABEL_SUFFIX)) {
                            ++inLabelCount;
                            continue;
                        }
                        if (!label.endsWith(WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX)) continue;
                        ++outLabelCount;
                    }
                }
            }
        }
        return inLabelCount == outLabelCount;
    }
}

