/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnPaginationFilterAdapter
implements TypedFilterAdapter<ColumnPaginationFilter> {
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("ColumnPaginationFilter requires specifying a single column family for the Scan when specifying a qualifier as the column offset.");

    @Override
    public RowFilter adapt(FilterAdapterContext context, ColumnPaginationFilter filter) throws IOException {
        if (filter.getColumnOffset() != null) {
            byte[] family = context.getScan().getFamilies()[0];
            return this.createChain(filter, RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(Bytes.toString((byte[])family)).setStartQualifierClosed(ByteString.copyFrom(filter.getColumnOffset()))));
        }
        if (filter.getOffset() > 0) {
            return this.createChain(filter, RowFilter.newBuilder().setCellsPerRowOffsetFilter(filter.getOffset()));
        }
        return this.createChain(filter, null);
    }

    private RowFilter createChain(ColumnPaginationFilter filter, RowFilter.Builder intermediate) {
        RowFilter.Chain.Builder builder = RowFilter.Chain.newBuilder();
        builder.addFilters(RowFilter.newBuilder().setCellsPerColumnLimitFilter(1));
        if (intermediate != null) {
            builder.addFilters(intermediate);
        }
        builder.addFilters(RowFilter.newBuilder().setCellsPerRowLimitFilter(filter.getLimit()));
        return RowFilter.newBuilder().setChain(builder).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnPaginationFilter filter) {
        int familyCount = context.getScan().numFamilies();
        if (filter.getColumnOffset() != null && familyCount != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

