/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReaderExpressionHelper;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;

public class ColumnPrefixFilterAdapter
implements TypedFilterAdapter<ColumnPrefixFilter> {
    ReaderExpressionHelper readerExpressionHelper = new ReaderExpressionHelper();

    @Override
    public RowFilter adapt(FilterAdapterContext context, ColumnPrefixFilter filter) throws IOException {
        byte[] prefix = filter.getPrefix();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(prefix.length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(outputStream, prefix);
        outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        return RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFrom(outputStream.toByteArray())).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

