/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ColumnCountGetFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ColumnPaginationFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ColumnPrefixFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ColumnRangeFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterListAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FirstKeyOnlyFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FuzzyRowFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.KeyOnlyFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.MultipleColumnPrefixFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.PageFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.PrefixFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.QualifierFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.RandomRowFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.RowFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.SingleColumnValueExcludeFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.SingleColumnValueFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.SingleFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TimestampsFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.UnsupportedFilterException;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.UnsupportedStatusCollector;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ValueFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.WhileMatchFilterAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;

public class FilterAdapter {
    private Map<Class<? extends Filter>, SingleFilterAdapter<?>> adapterMap = new HashMap();

    public static FilterAdapter buildAdapter() {
        FilterAdapter adapter = new FilterAdapter();
        adapter.addFilterAdapter(ColumnPrefixFilter.class, new ColumnPrefixFilterAdapter());
        adapter.addFilterAdapter(ColumnRangeFilter.class, new ColumnRangeFilterAdapter());
        adapter.addFilterAdapter(KeyOnlyFilter.class, new KeyOnlyFilterAdapter());
        adapter.addFilterAdapter(MultipleColumnPrefixFilter.class, new MultipleColumnPrefixFilterAdapter());
        adapter.addFilterAdapter(TimestampsFilter.class, new TimestampsFilterAdapter());
        ValueFilterAdapter valueFilterAdapter = new ValueFilterAdapter();
        adapter.addFilterAdapter(ValueFilter.class, valueFilterAdapter);
        SingleColumnValueFilterAdapter scvfa = new SingleColumnValueFilterAdapter(valueFilterAdapter);
        adapter.addFilterAdapter(SingleColumnValueFilter.class, scvfa);
        adapter.addFilterAdapter(SingleColumnValueExcludeFilter.class, new SingleColumnValueExcludeFilterAdapter(scvfa));
        adapter.addFilterAdapter(ColumnPaginationFilter.class, new ColumnPaginationFilterAdapter());
        adapter.addFilterAdapter(FirstKeyOnlyFilter.class, new FirstKeyOnlyFilterAdapter());
        adapter.addFilterAdapter(ColumnCountGetFilter.class, new ColumnCountGetFilterAdapter());
        adapter.addFilterAdapter(RandomRowFilter.class, new RandomRowFilterAdapter());
        adapter.addFilterAdapter(PrefixFilter.class, new PrefixFilterAdapter());
        adapter.addFilterAdapter(QualifierFilter.class, new QualifierFilterAdapter());
        adapter.addFilterAdapter(PageFilter.class, new PageFilterAdapter());
        adapter.addFilterAdapter(WhileMatchFilter.class, new WhileMatchFilterAdapter(adapter));
        adapter.addFilterAdapter(org.apache.hadoop.hbase.filter.RowFilter.class, new RowFilterAdapter());
        adapter.addFilterAdapter(FuzzyRowFilter.class, new FuzzyRowFilterAdapter());
        FilterListAdapter filterListAdapter = new FilterListAdapter(adapter);
        adapter.addFilterAdapter(FilterList.class, filterListAdapter, filterListAdapter);
        return adapter;
    }

    private <T extends Filter> void addFilterAdapter(Class<T> filterType, TypedFilterAdapter<T> typedFilterAdapter) {
        this.adapterMap.put(filterType, new SingleFilterAdapter<T>(filterType, typedFilterAdapter));
    }

    private <T extends Filter> void addFilterAdapter(Class<T> filterType, TypedFilterAdapter<T> typedFilterAdapter, UnsupportedStatusCollector<T> collector) {
        this.adapterMap.put(filterType, new SingleFilterAdapter<T>(filterType, typedFilterAdapter, collector));
    }

    protected FilterAdapter() {
    }

    public Optional<RowFilter> adaptFilter(FilterAdapterContext context, Filter filter) throws IOException {
        SingleFilterAdapter<?> adapter = this.getAdapterForFilterOrThrow(filter);
        return Optional.fromNullable(adapter.adapt(context, filter));
    }

    public void throwIfUnsupportedFilter(Scan scan, Filter filter) {
        ArrayList<FilterSupportStatus> filterSupportStatuses = new ArrayList<FilterSupportStatus>();
        FilterAdapterContext context = new FilterAdapterContext(scan, null);
        this.collectUnsupportedStatuses(context, filter, filterSupportStatuses);
        if (!filterSupportStatuses.isEmpty()) {
            throw new UnsupportedFilterException(filterSupportStatuses);
        }
    }

    public void collectUnsupportedStatuses(FilterAdapterContext context, Filter filter, List<FilterSupportStatus> statuses) {
        SingleFilterAdapter<?> adapter = this.adapterMap.get(filter.getClass());
        if (adapter == null) {
            statuses.add(FilterSupportStatus.newUnknownFilterType(filter));
        } else {
            adapter.collectUnsupportedStatuses(context, filter, statuses);
        }
    }

    protected SingleFilterAdapter<?> getAdapterForFilterOrThrow(Filter filter) {
        if (this.adapterMap.containsKey(filter.getClass())) {
            return this.adapterMap.get(filter.getClass());
        }
        throw new UnsupportedFilterException(ImmutableList.of(FilterSupportStatus.newUnknownFilterType(filter)));
    }
}

