/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReaderExpressionHelper;
import com.google.bigtable.repackaged.com.google.cloud.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;

public class MultipleColumnPrefixFilterAdapter
implements TypedFilterAdapter<MultipleColumnPrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, MultipleColumnPrefixFilter filter) throws IOException {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        ByteArrayOutputStream outputStream = null;
        for (byte[] prefix : filter.getPrefix()) {
            if (outputStream == null) {
                outputStream = new ByteArrayOutputStream(prefix.length * 2);
            }
            outputStream.reset();
            ReaderExpressionHelper.writeQuotedExpression(outputStream, prefix);
            outputStream.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
            RowFilter.Builder singlePrefixBuilder = RowFilter.newBuilder();
            singlePrefixBuilder.setColumnQualifierRegexFilter(ByteStringer.wrap(outputStream.toByteArray()));
            interleaveBuilder.addFilters(singlePrefixBuilder);
        }
        return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, MultipleColumnPrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

