/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;

public class PageFilterAdapter
implements TypedFilterAdapter<PageFilter> {
    private static final FilterSupportStatus TOP_LEVEL_ONLY = FilterSupportStatus.newNotSupported("Page filters may only appear as top level filters or be contained within a top-level FilterList instances with MUST_PASS_ALL as its Operator");

    @Override
    public RowFilter adapt(FilterAdapterContext context, PageFilter filter) throws IOException {
        final long pageSize = filter.getPageSize();
        context.getReadHooks().composePreSendHook(new Function<ReadRowsRequest, ReadRowsRequest>(){

            @Override
            public ReadRowsRequest apply(ReadRowsRequest request) {
                return request.toBuilder().setRowsLimit(pageSize).build();
            }
        });
        return null;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PageFilter filter) {
        Optional<FilterList> currentList = context.getCurrentFilterList();
        if (currentList.isPresent() && !PageFilterAdapter.isFilterListSupported(currentList.get(), filter) || context.getFilterListDepth() > 1) {
            return TOP_LEVEL_ONLY;
        }
        return FilterSupportStatus.SUPPORTED;
    }

    private static boolean isFilterListSupported(FilterList list, PageFilter currentFilter) {
        return list.getOperator() == FilterList.Operator.MUST_PASS_ALL && list.getFilters().indexOf(currentFilter) == list.getFilters().size() - 1;
    }
}

