/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReaderExpressionHelper;
import com.google.bigtable.repackaged.com.google.cloud.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.PrefixFilter;

public class PrefixFilterAdapter
implements TypedFilterAdapter<PrefixFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, PrefixFilter filter) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(filter.getPrefix().length * 2);
        ReaderExpressionHelper.writeQuotedRegularExpression(baos, filter.getPrefix());
        baos.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        ByteString quotedValue = ByteStringer.wrap(baos.toByteArray());
        return RowFilter.newBuilder().setRowKeyRegexFilter(quotedValue).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

