/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReaderExpressionHelper;
import com.google.bigtable.repackaged.com.google.cloud.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;

public class RowFilterAdapter
implements TypedFilterAdapter<org.apache.hadoop.hbase.filter.RowFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, org.apache.hadoop.hbase.filter.RowFilter filter) throws IOException {
        CompareFilter.CompareOp compareOp = filter.getOperator();
        if (compareOp != CompareFilter.CompareOp.EQUAL) {
            throw new IllegalStateException(String.format("Cannot adapt operator %s", compareOp == null ? null : compareOp.getClass().getCanonicalName()));
        }
        ByteArrayComparable comparator = filter.getComparator();
        RowFilter.Builder builder = RowFilter.newBuilder();
        if (comparator == null) {
            throw new IllegalStateException("Comparator cannot be null");
        }
        if (comparator instanceof RegexStringComparator) {
            ByteString rawValue = ByteString.copyFrom(comparator.getValue());
            builder.setRowKeyRegexFilter(rawValue);
        } else if (comparator instanceof BinaryComparator) {
            byte[] quotedRegularExpression = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
            builder.setRowKeyRegexFilter(ByteStringer.wrap(quotedRegularExpression));
        } else {
            throw new IllegalStateException(String.format("Cannot adapt comparator %s", comparator.getClass().getCanonicalName()));
        }
        return builder.build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, org.apache.hadoop.hbase.filter.RowFilter filter) {
        ByteArrayComparable comparator = filter.getComparator();
        if (!(comparator instanceof RegexStringComparator) && !(comparator instanceof BinaryComparator)) {
            return FilterSupportStatus.newNotSupported(comparator.getClass().getName() + " comparator is not supported");
        }
        if (filter.getOperator() != CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.newNotSupported(filter.getOperator() + " operator is not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

