/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.SingleColumnValueFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class SingleColumnValueExcludeFilterAdapter
implements TypedFilterAdapter<SingleColumnValueExcludeFilter> {
    private static final String REQUIRE_SINGLE_FAMILY_MESSAGE = "Scan or Get operations using SingleColumnValueExcludeFilter must have a single family specified with #addFamily().";
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("Scan or Get operations using SingleColumnValueExcludeFilter must have a single family specified with #addFamily().");
    private final SingleColumnValueFilterAdapter delegateAdapter;

    public SingleColumnValueExcludeFilterAdapter(SingleColumnValueFilterAdapter delegateAdapter) {
        this.delegateAdapter = delegateAdapter;
    }

    @Override
    public RowFilter adapt(FilterAdapterContext context, SingleColumnValueExcludeFilter filter) throws IOException {
        RowFilter excludeMatchColumnFilter = this.makeExcludeMatchColumnFilter(context.getScan(), filter);
        return RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(this.delegateAdapter.adapt(context, (SingleColumnValueFilter)filter)).addFilters(excludeMatchColumnFilter)).build();
    }

    private RowFilter makeExcludeMatchColumnFilter(Scan scan, SingleColumnValueExcludeFilter filter) {
        String family = Bytes.toString((byte[])scan.getFamilies()[0]);
        ByteString qualifier = ByteString.copyFrom(filter.getQualifier());
        return RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addFilters(RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(family).setEndQualifierOpen(qualifier))).addFilters(RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName(family).setStartQualifierOpen(qualifier)))).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, SingleColumnValueExcludeFilter filter) {
        FilterSupportStatus delegateStatus = this.delegateAdapter.isFilterSupported(context, (SingleColumnValueFilter)filter);
        if (!delegateStatus.isSupported()) {
            return delegateStatus;
        }
        if (context.getScan().numFamilies() != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

