/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapterContext;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterSupportStatus;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.TypedFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.ValueFilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReaderExpressionHelper;
import com.google.bigtable.repackaged.com.google.cloud.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowFilter;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class SingleColumnValueFilterAdapter
implements TypedFilterAdapter<SingleColumnValueFilter> {
    private static final RowFilter ALL_VALUES_FILTER = RowFilter.newBuilder().setCellsPerColumnLimitFilter(Integer.MAX_VALUE).build();
    private final ValueFilterAdapter delegateAdapter;

    public SingleColumnValueFilterAdapter(ValueFilterAdapter delegateAdapter) {
        this.delegateAdapter = delegateAdapter;
    }

    @Override
    public RowFilter adapt(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        if (filter.getFilterIfMissing()) {
            return this.createEmitRowsWithValueFilter(context, filter);
        }
        return RowFilter.newBuilder().setCondition(RowFilter.Condition.newBuilder().setPredicateFilter(this.createColumnSpecFilter(filter)).setTrueFilter(this.createEmitRowsWithValueFilter(context, filter)).setFalseFilter(ALL_VALUES_FILTER)).build();
    }

    private RowFilter createColumnSpecFilter(SingleColumnValueFilter filter) throws IOException {
        return RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(RowFilter.newBuilder().setFamilyNameRegexFilter(Bytes.toString((byte[])ReaderExpressionHelper.quoteRegularExpression(filter.getFamily())))).addFilters(RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteStringer.wrap(ReaderExpressionHelper.quoteRegularExpression(filter.getQualifier())))).addFilters(this.createVersionLimitFilter(filter))).build();
    }

    private RowFilter createVersionLimitFilter(SingleColumnValueFilter filter) {
        return RowFilter.newBuilder().setCellsPerColumnLimitFilter(filter.getLatestVersionOnly() ? 1 : Integer.MAX_VALUE).build();
    }

    private ValueFilter createValueFilter(SingleColumnValueFilter filter) {
        return new ValueFilter(filter.getOperator(), filter.getComparator());
    }

    private RowFilter createValueMatchFilter(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        ValueFilter valueFilter = this.createValueFilter(filter);
        return this.delegateAdapter.adapt(context, valueFilter);
    }

    private RowFilter createEmitRowsWithValueFilter(FilterAdapterContext context, SingleColumnValueFilter filter) throws IOException {
        return RowFilter.newBuilder().setCondition(RowFilter.Condition.newBuilder().setPredicateFilter(RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(this.createColumnSpecFilter(filter)).addFilters(this.createValueMatchFilter(context, filter)))).setTrueFilter(ALL_VALUES_FILTER)).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, SingleColumnValueFilter filter) {
        return this.delegateAdapter.isFilterSupported(context, this.createValueFilter(filter));
    }
}

