/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.ResponseAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.RowCell;
import com.google.bigtable.repackaged.com.google.cloud.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Cell;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Column;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Family;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.protobuf.BigtableZeroCopyByteStringUtil;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class RowAdapter
implements ResponseAdapter<Row, Result> {
    static final long TIME_CONVERSION_UNIT = BigtableConstants.BIGTABLE_TIMEUNIT.convert(1L, BigtableConstants.HBASE_TIMEUNIT);

    @Override
    public Result adaptResponse(Row response) {
        if (response == null) {
            return new Result();
        }
        TreeSet<RowCell> hbaseCells = new TreeSet<RowCell>((Comparator<RowCell>)KeyValue.COMPARATOR);
        byte[] rowKey = ByteStringer.extract(response.getKey());
        for (Family family : response.getFamiliesList()) {
            byte[] familyNameBytes = Bytes.toBytes((String)family.getName());
            for (Column column : family.getColumnsList()) {
                byte[] columnQualifier = ByteStringer.extract(column.getQualifier());
                for (Cell cell : column.getCellsList()) {
                    if (cell.getLabelsCount() > 0) continue;
                    long hbaseTimestamp = cell.getTimestampMicros() / TIME_CONVERSION_UNIT;
                    RowCell keyValue = new RowCell(rowKey, familyNameBytes, columnQualifier, hbaseTimestamp, ByteStringer.extract(cell.getValue()));
                    hbaseCells.add(keyValue);
                }
            }
        }
        return Result.create((org.apache.hadoop.hbase.Cell[])hbaseCells.toArray(new org.apache.hadoop.hbase.Cell[hbaseCells.size()]));
    }

    public Row adaptToRow(Result result) {
        NavigableMap familyMap;
        Row.Builder rowBuilder = Row.newBuilder();
        if (result.getRow() != null) {
            rowBuilder.setKey(BigtableZeroCopyByteStringUtil.wrap(result.getRow()));
        }
        if ((familyMap = result.getMap()) != null) {
            for (Map.Entry familyEntry : familyMap.entrySet()) {
                Family.Builder familyBuilder = rowBuilder.addFamiliesBuilder().setName(Bytes.toString((byte[])((byte[])familyEntry.getKey())));
                for (Map.Entry columnEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                    Column.Builder columnBuilder = familyBuilder.addColumnsBuilder().setQualifier(BigtableZeroCopyByteStringUtil.wrap((byte[])columnEntry.getKey()));
                    for (Map.Entry cellData : ((NavigableMap)columnEntry.getValue()).entrySet()) {
                        columnBuilder.addCellsBuilder().setTimestampMicros((Long)cellData.getKey() * TIME_CONVERSION_UNIT).setValue(BigtableZeroCopyByteStringUtil.wrap((byte[])cellData.getValue()));
                    }
                }
            }
        }
        return rowBuilder.build();
    }
}

