/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

public class RowCell
implements Cell {
    private final byte[] rowArray;
    private final byte[] familyArray;
    private final byte[] qualifierArray;
    private final long timestamp;
    private final byte[] valueArray;

    public RowCell(byte[] rowArray, byte[] familyArray, byte[] qualifierArray, long timestamp, byte[] valueArray) {
        this.rowArray = rowArray;
        this.familyArray = familyArray;
        this.qualifierArray = qualifierArray;
        this.timestamp = timestamp;
        this.valueArray = valueArray;
    }

    public byte[] getRowArray() {
        return this.rowArray;
    }

    public int getRowOffset() {
        return 0;
    }

    public short getRowLength() {
        return (short)this.rowArray.length;
    }

    public byte[] getFamilyArray() {
        return this.familyArray;
    }

    public int getFamilyOffset() {
        return 0;
    }

    public byte getFamilyLength() {
        return (byte)this.familyArray.length;
    }

    public byte[] getQualifierArray() {
        return this.qualifierArray;
    }

    public int getQualifierOffset() {
        return 0;
    }

    public int getQualifierLength() {
        return this.qualifierArray.length;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getTypeByte() {
        return KeyValue.Type.Put.getCode();
    }

    @Deprecated
    public long getMvccVersion() {
        return 0L;
    }

    public long getSequenceId() {
        return 0L;
    }

    public byte[] getValueArray() {
        return this.valueArray;
    }

    public int getValueOffset() {
        return 0;
    }

    public int getValueLength() {
        return this.valueArray.length;
    }

    public byte[] getTagsArray() {
        return HConstants.EMPTY_BYTE_ARRAY;
    }

    public int getTagsOffset() {
        return 0;
    }

    public int getTagsLength() {
        return 0;
    }

    @Deprecated
    public byte[] getValue() {
        return Bytes.copy((byte[])this.valueArray);
    }

    @Deprecated
    public byte[] getFamily() {
        return Bytes.copy((byte[])this.familyArray);
    }

    @Deprecated
    public byte[] getQualifier() {
        return Bytes.copy((byte[])this.qualifierArray);
    }

    @Deprecated
    public byte[] getRow() {
        return Bytes.copy((byte[])this.rowArray);
    }
}

