/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.protobuf;

import com.google.bigtable.repackaged.com.google.protobuf.BoundedByteString;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.CodedInputStream;
import com.google.bigtable.repackaged.com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LiteralByteString
extends ByteString.LeafByteString {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;

    LiteralByteString(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public final ByteString substring(int beginIndex, int endIndex) {
        int length = LiteralByteString.checkRange(beginIndex, endIndex, this.size());
        if (length == 0) {
            return ByteString.EMPTY;
        }
        return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + beginIndex, length);
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
    }

    @Override
    public final void copyTo(ByteBuffer target) {
        target.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public final ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
    }

    @Override
    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    @Override
    final void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + sourceOffset, numberToWrite);
    }

    @Override
    protected final String toStringInternal(Charset charset) {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
    }

    @Override
    public final boolean isValidUtf8() {
        int offset = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8(this.bytes, offset, offset + this.size());
    }

    @Override
    protected final int partialIsValidUtf8(int state, int offset, int length) {
        int index = this.getOffsetIntoBytes() + offset;
        return Utf8.partialIsValidUtf8(state, this.bytes, index, index + length);
    }

    @Override
    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)other).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof LiteralByteString) {
            LiteralByteString otherAsLiteral = (LiteralByteString)other;
            int thisHash = this.peekCachedHashCode();
            int thatHash = otherAsLiteral.peekCachedHashCode();
            if (thisHash != 0 && thatHash != 0 && thisHash != thatHash) {
                return false;
            }
            return this.equalsRange((LiteralByteString)other, 0, this.size());
        }
        return other.equals(this);
    }

    @Override
    final boolean equalsRange(ByteString other, int offset, int length) {
        if (length > other.size()) {
            throw new IllegalArgumentException("Length too large: " + length + this.size());
        }
        if (offset + length > other.size()) {
            throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
        }
        if (other instanceof LiteralByteString) {
            LiteralByteString lbsOther = (LiteralByteString)other;
            byte[] thisBytes = this.bytes;
            byte[] otherBytes = lbsOther.bytes;
            int thisLimit = this.getOffsetIntoBytes() + length;
            int thisIndex = this.getOffsetIntoBytes();
            int otherIndex = lbsOther.getOffsetIntoBytes() + offset;
            while (thisIndex < thisLimit) {
                if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                    return false;
                }
                ++thisIndex;
                ++otherIndex;
            }
            return true;
        }
        return other.substring(offset, offset + length).equals(this.substring(0, length));
    }

    @Override
    protected final int partialHash(int h, int offset, int length) {
        return LiteralByteString.hashCode(h, this.bytes, this.getOffsetIntoBytes() + offset, length);
    }

    static int hashCode(int h, byte[] bytes, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            h = h * 31 + bytes[i];
        }
        return h;
    }

    static int hashCode(byte[] bytes) {
        int h = LiteralByteString.hashCode(bytes.length, bytes, 0, bytes.length);
        return h == 0 ? 1 : h;
    }

    @Override
    public final InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this);
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }
}

