/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.protobuf;

import com.google.bigtable.repackaged.com.google.protobuf.AbstractProtobufList;
import com.google.bigtable.repackaged.com.google.protobuf.Internal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal.LongList,
RandomAccess {
    private static final int DEFAULT_CAPACITY = 10;
    private static final LongArrayList EMPTY_LIST = new LongArrayList();
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(10);
    }

    LongArrayList(int capacity) {
        this.array = new long[capacity];
        this.size = 0;
    }

    LongArrayList(List<Long> other) {
        if (other instanceof LongArrayList) {
            LongArrayList list = (LongArrayList)other;
            this.array = (long[])list.array.clone();
            this.size = list.size;
        } else {
            this.size = other.size();
            this.array = new long[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.array[i] = other.get(i);
            }
        }
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Long set(int index, Long element) {
        return this.setLong(index, element);
    }

    @Override
    public long setLong(int index, long element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long previousValue = this.array[index];
        this.array[index] = element;
        return previousValue;
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, element);
    }

    @Override
    public void addLong(long element) {
        this.addLong(this.size, element);
    }

    private void addLong(int index, long element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int length = this.size * 3 / 2 + 1;
            long[] newArray = new long[length];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
            this.array = newArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        this.ensureIsMutable();
        if (collection == null) {
            throw new NullPointerException();
        }
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList list = (LongArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, list.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Long remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        long value = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        --this.size;
        ++this.modCount;
        return value;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

