/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.protobuf.util;

import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import com.google.bigtable.repackaged.com.google.protobuf.Timestamp;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimeUtil {
    public static final long TIMESTAMP_SECONDS_MIN = -62135596800L;
    public static final long TIMESTAMP_SECONDS_MAX = 253402300799L;
    public static final long DURATION_SECONDS_MIN = -315576000000L;
    public static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long NANOS_PER_MICROSECOND = 1000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final ThreadLocal<SimpleDateFormat> timestampFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return TimeUtil.createTimestampFormat();
        }
    };
    private static final BigInteger NANOS_PER_SECOND_BIG_INTEGER = new BigInteger(String.valueOf(1000000000L));

    private static SimpleDateFormat createTimestampFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    }

    private TimeUtil() {
    }

    public static String toString(Timestamp timestamp) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        if (timestamp.getSeconds() < -62135596800L || timestamp.getSeconds() > 253402300799L) {
            throw new IllegalArgumentException("Timestamp is out of range.");
        }
        Date date = new Date(timestamp.getSeconds() * 1000L);
        result.append(timestampFormat.get().format(date));
        if (timestamp.getNanos() < 0 || (long)timestamp.getNanos() >= 1000000000L) {
            throw new IllegalArgumentException("Timestamp has invalid nanos value.");
        }
        if (timestamp.getNanos() != 0) {
            result.append(".");
            result.append(TimeUtil.formatNanos(timestamp.getNanos()));
        }
        result.append("Z");
        return result.toString();
    }

    public static Timestamp parseTimestamp(String value) throws ParseException {
        int nanos;
        String timeValue;
        int dayOffset = value.indexOf(84);
        if (dayOffset == -1) {
            throw new ParseException("Failed to parse timestamp: invalid timestamp \"" + value + "\"", 0);
        }
        int timezoneOffsetPosition = value.indexOf(90, dayOffset);
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value.indexOf(43, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            timezoneOffsetPosition = value.indexOf(45, dayOffset);
        }
        if (timezoneOffsetPosition == -1) {
            throw new ParseException("Failed to parse timestamp: missing valid timezone offset.", 0);
        }
        String secondValue = timeValue = value.substring(0, timezoneOffsetPosition);
        String nanoValue = "";
        int pointPosition = timeValue.indexOf(46);
        if (pointPosition != -1) {
            secondValue = timeValue.substring(0, pointPosition);
            nanoValue = timeValue.substring(pointPosition + 1);
        }
        Date date = timestampFormat.get().parse(secondValue);
        long seconds = date.getTime() / 1000L;
        int n = nanos = nanoValue.isEmpty() ? 0 : TimeUtil.parseNanos(nanoValue);
        if (value.charAt(timezoneOffsetPosition) == 'Z') {
            if (value.length() != timezoneOffsetPosition + 1) {
                throw new ParseException("Failed to parse timestamp: invalid trailing data \"" + value.substring(timezoneOffsetPosition) + "\"", 0);
            }
        } else {
            String offsetValue = value.substring(timezoneOffsetPosition + 1);
            long offset = TimeUtil.parseTimezoneOffset(offsetValue);
            seconds = value.charAt(timezoneOffsetPosition) == '+' ? (seconds -= offset) : (seconds += offset);
        }
        try {
            return TimeUtil.normalizedTimestamp(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Failed to parse timestmap: timestamp is out of range.", 0);
        }
    }

    public static String toString(Duration duration) throws IllegalArgumentException {
        if (duration.getSeconds() < -315576000000L || duration.getSeconds() > 315576000000L) {
            throw new IllegalArgumentException("Duration is out of valid range.");
        }
        StringBuilder result = new StringBuilder();
        long seconds = duration.getSeconds();
        int nanos = duration.getNanos();
        if (seconds < 0L || nanos < 0) {
            if (seconds > 0L || nanos > 0) {
                throw new IllegalArgumentException("Invalid duration: seconds value and nanos value must have the samesign.");
            }
            result.append("-");
            seconds = -seconds;
            nanos = -nanos;
        }
        result.append(seconds);
        if (nanos != 0) {
            result.append(".");
            result.append(TimeUtil.formatNanos(nanos));
        }
        result.append("s");
        return result.toString();
    }

    public static Duration parseDuration(String value) throws ParseException {
        int nanos;
        if (value.isEmpty() || value.charAt(value.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        boolean negative = false;
        if (value.charAt(0) == '-') {
            negative = true;
            value = value.substring(1);
        }
        String secondValue = value.substring(0, value.length() - 1);
        String nanoValue = "";
        int pointPosition = secondValue.indexOf(46);
        if (pointPosition != -1) {
            nanoValue = secondValue.substring(pointPosition + 1);
            secondValue = secondValue.substring(0, pointPosition);
        }
        long seconds = Long.parseLong(secondValue);
        int n = nanos = nanoValue.isEmpty() ? 0 : TimeUtil.parseNanos(nanoValue);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        try {
            return TimeUtil.normalizedDuration(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    public static Timestamp createTimestampFromMillis(long milliseconds) {
        return TimeUtil.normalizedTimestamp(milliseconds / 1000L, (int)(milliseconds % 1000L * 1000000L));
    }

    public static Duration createDurationFromMillis(long milliseconds) {
        return TimeUtil.normalizedDuration(milliseconds / 1000L, (int)(milliseconds % 1000L * 1000000L));
    }

    public static long toMillis(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000L + (long)timestamp.getNanos() / 1000000L;
    }

    public static long toMillis(Duration duration) {
        return duration.getSeconds() * 1000L + (long)duration.getNanos() / 1000000L;
    }

    public static Timestamp createTimestampFromMicros(long microseconds) {
        return TimeUtil.normalizedTimestamp(microseconds / 1000000L, (int)(microseconds % 1000000L * 1000L));
    }

    public static Duration createDurationFromMicros(long microseconds) {
        return TimeUtil.normalizedDuration(microseconds / 1000000L, (int)(microseconds % 1000000L * 1000L));
    }

    public static long toMicros(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000000L + (long)timestamp.getNanos() / 1000L;
    }

    public static long toMicros(Duration duration) {
        return duration.getSeconds() * 1000000L + (long)duration.getNanos() / 1000L;
    }

    public static Timestamp createTimestampFromNanos(long nanoseconds) {
        return TimeUtil.normalizedTimestamp(nanoseconds / 1000000000L, (int)(nanoseconds % 1000000000L));
    }

    public static Duration createDurationFromNanos(long nanoseconds) {
        return TimeUtil.normalizedDuration(nanoseconds / 1000000000L, (int)(nanoseconds % 1000000000L));
    }

    public static long toNanos(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000000000L + (long)timestamp.getNanos();
    }

    public static long toNanos(Duration duration) {
        return duration.getSeconds() * 1000000000L + (long)duration.getNanos();
    }

    public static Timestamp getCurrentTime() {
        return TimeUtil.createTimestampFromMillis(System.currentTimeMillis());
    }

    public static Timestamp getEpoch() {
        return Timestamp.getDefaultInstance();
    }

    public static Duration distance(Timestamp from, Timestamp to) {
        return TimeUtil.normalizedDuration(to.getSeconds() - from.getSeconds(), to.getNanos() - from.getNanos());
    }

    public static Timestamp add(Timestamp start, Duration length) {
        return TimeUtil.normalizedTimestamp(start.getSeconds() + length.getSeconds(), start.getNanos() + length.getNanos());
    }

    public static Timestamp subtract(Timestamp start, Duration length) {
        return TimeUtil.normalizedTimestamp(start.getSeconds() - length.getSeconds(), start.getNanos() - length.getNanos());
    }

    public static Duration add(Duration d1, Duration d2) {
        return TimeUtil.normalizedDuration(d1.getSeconds() + d2.getSeconds(), d1.getNanos() + d2.getNanos());
    }

    public static Duration subtract(Duration d1, Duration d2) {
        return TimeUtil.normalizedDuration(d1.getSeconds() - d2.getSeconds(), d1.getNanos() - d2.getNanos());
    }

    public static Duration multiply(Duration duration, double times) {
        double result = (double)duration.getSeconds() * times + (double)duration.getNanos() * times / 1.0E9;
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new IllegalArgumentException("Result is out of valid range.");
        }
        long seconds = (long)result;
        int nanos = (int)((result - (double)seconds) * 1.0E9);
        return TimeUtil.normalizedDuration(seconds, nanos);
    }

    public static Duration divide(Duration duration, double value) {
        return TimeUtil.multiply(duration, 1.0 / value);
    }

    public static Duration multiply(Duration duration, long times) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(duration).multiply(TimeUtil.toBigInteger(times)));
    }

    public static Duration divide(Duration duration, long times) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(duration).divide(TimeUtil.toBigInteger(times)));
    }

    public static long divide(Duration d1, Duration d2) {
        return TimeUtil.toBigInteger(d1).divide(TimeUtil.toBigInteger(d2)).longValue();
    }

    public static Duration remainder(Duration d1, Duration d2) {
        return TimeUtil.createDurationFromBigInteger(TimeUtil.toBigInteger(d1).remainder(TimeUtil.toBigInteger(d2)));
    }

    private static BigInteger toBigInteger(Duration duration) {
        return TimeUtil.toBigInteger(duration.getSeconds()).multiply(NANOS_PER_SECOND_BIG_INTEGER).add(TimeUtil.toBigInteger(duration.getNanos()));
    }

    private static BigInteger toBigInteger(long value) {
        return new BigInteger(String.valueOf(value));
    }

    private static Duration createDurationFromBigInteger(BigInteger value) {
        long seconds = value.divide(new BigInteger(String.valueOf(1000000000L))).longValue();
        int nanos = value.remainder(new BigInteger(String.valueOf(1000000000L))).intValue();
        return TimeUtil.normalizedDuration(seconds, nanos);
    }

    private static Duration normalizedDuration(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds += (long)nanos / 1000000000L;
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (seconds > 0L && nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos = (int)((long)nanos - 1000000000L);
            ++seconds;
        }
        if (seconds < -315576000000L || seconds > 315576000000L) {
            throw new IllegalArgumentException("Duration is out of valid range.");
        }
        return Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    private static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds += (long)nanos / 1000000000L;
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            --seconds;
        }
        if (seconds < -62135596800L || seconds > 253402300799L) {
            throw new IllegalArgumentException("Timestamp is out of valid range.");
        }
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    private static String formatNanos(int nanos) {
        assert (nanos >= 1 && nanos <= 999999999);
        if ((long)nanos % 1000000L == 0L) {
            return String.format("%1$03d", (long)nanos / 1000000L);
        }
        if ((long)nanos % 1000L == 0L) {
            return String.format("%1$06d", (long)nanos / 1000L);
        }
        return String.format("%1$09d", nanos);
    }

    private static int parseNanos(String value) throws ParseException {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value.length()) continue;
            if (value.charAt(i) < '0' || value.charAt(i) > '9') {
                throw new ParseException("Invalid nanosecnds.", 0);
            }
            result += value.charAt(i) - 48;
        }
        return result;
    }

    private static long parseTimezoneOffset(String value) throws ParseException {
        int pos = value.indexOf(58);
        if (pos == -1) {
            throw new ParseException("Invalid offset value: " + value, 0);
        }
        String hours = value.substring(0, pos);
        String minutes = value.substring(pos + 1);
        return (Long.parseLong(hours) * 60L + Long.parseLong(minutes)) * 60L;
    }
}

