/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Attributes {
    private final HashMap<Key<?>, Object> data = new HashMap();
    public static final Attributes EMPTY = new Attributes();

    private Attributes() {
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.data.get(key);
    }

    public Set<Key<?>> keys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.data.toString();
    }

    public static final class Builder {
        private Attributes product = new Attributes();

        private Builder() {
        }

        public <T> Builder set(Key<T> key, T value) {
            this.product.data.put(key, value);
            return this;
        }

        public Attributes build() {
            Preconditions.checkState(this.product != null, "Already built");
            Attributes result = this.product;
            this.product = null;
            return result;
        }
    }

    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static <T> Key<T> of(String name) {
            return new Key<T>(name);
        }
    }
}

