/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Deadline deadline;
    private Executor executor;
    @Nullable
    private String authority;
    private Attributes affinity = Attributes.EMPTY;
    @Nullable
    private String compressorName;

    public CallOptions withAuthority(@Nullable String authority) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.authority = authority;
        return newOptions;
    }

    public CallOptions withCompression(@Nullable String compressorName) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.compressorName = compressorName;
        return newOptions;
    }

    public CallOptions withDeadline(@Nullable Deadline deadline) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.deadline = deadline;
        return newOptions;
    }

    @Deprecated
    public CallOptions withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        Deadline deadline = deadlineNanoTime != null ? Deadline.after(deadlineNanoTime - System.nanoTime(), TimeUnit.NANOSECONDS) : null;
        return this.withDeadline(deadline);
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadline(Deadline.after(duration, unit));
    }

    @Deprecated
    public Long getDeadlineNanoTime() {
        if (this.getDeadline() == null) {
            return null;
        }
        return System.nanoTime() + this.getDeadline().timeRemaining(TimeUnit.NANOSECONDS);
    }

    @Nullable
    public Deadline getDeadline() {
        return this.deadline;
    }

    public CallOptions withAffinity(Attributes affinity) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.affinity = Preconditions.checkNotNull(affinity);
        return newOptions;
    }

    public Attributes getAffinity() {
        return this.affinity;
    }

    @Nullable
    public String getCompressor() {
        return this.compressorName;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    public CallOptions withExecutor(Executor executor) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.executor = executor;
        return newOptions;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    private CallOptions() {
    }

    private CallOptions(CallOptions other) {
        this.deadline = other.deadline;
        this.authority = other.authority;
        this.affinity = other.affinity;
        this.executor = other.executor;
        this.compressorName = other.compressorName;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
        toStringHelper.add("deadline", this.deadline);
        toStringHelper.add("authority", this.authority);
        toStringHelper.add("affinity", this.affinity);
        toStringHelper.add("executor", this.executor != null ? this.executor.getClass() : null);
        toStringHelper.add("compressorName", this.compressorName);
        return toStringHelper.toString();
    }
}

