/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DecompressorRegistry {
    private static final DecompressorRegistry DEFAULT_INSTANCE = new DecompressorRegistry(new DecompressorInfo(new Codec.Gzip(), true), new DecompressorInfo(Codec.Identity.NONE, false));
    private final ConcurrentMap<String, DecompressorInfo> decompressors = new ConcurrentHashMap<String, DecompressorInfo>();

    public static DecompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static DecompressorRegistry newEmptyInstance() {
        return new DecompressorRegistry(new DecompressorInfo[0]);
    }

    public void register(Decompressor d, boolean advertised) {
        String encoding = d.getMessageEncoding();
        Preconditions.checkArgument(!encoding.contains(","), "Comma is currently not allowed in message encoding");
        this.decompressors.put(encoding, new DecompressorInfo(d, advertised));
    }

    public Set<String> getKnownMessageEncodings() {
        return Collections.unmodifiableSet(this.decompressors.keySet());
    }

    public Set<String> getAdvertisedMessageEncodings() {
        HashSet advertisedDecompressors = new HashSet(this.decompressors.size());
        for (Map.Entry entry : this.decompressors.entrySet()) {
            if (!((DecompressorInfo)entry.getValue()).advertised) continue;
            advertisedDecompressors.add(entry.getKey());
        }
        return Collections.unmodifiableSet(advertisedDecompressors);
    }

    @Nullable
    public Decompressor lookupDecompressor(String messageEncoding) {
        DecompressorInfo info = (DecompressorInfo)this.decompressors.get(messageEncoding);
        return info != null ? info.decompressor : null;
    }

    @VisibleForTesting
    DecompressorRegistry(DecompressorInfo ... ds) {
        for (DecompressorInfo d : ds) {
            this.decompressors.put(d.decompressor.getMessageEncoding(), d);
        }
    }

    private static final class DecompressorInfo {
        private final Decompressor decompressor;
        private volatile boolean advertised;

        DecompressorInfo(Decompressor decompressor, boolean advertised) {
            this.decompressor = Preconditions.checkNotNull(decompressor);
            this.advertised = advertised;
        }
    }
}

