/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.DnsNameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import java.net.URI;

public final class DnsNameResolverFactory
extends NameResolver.Factory {
    private static final String SCHEME = "dns";
    private static final DnsNameResolverFactory instance = new DnsNameResolverFactory();

    @Override
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", targetPath, targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, params, GrpcUtil.TIMER_SERVICE, GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    private DnsNameResolverFactory() {
    }

    public static DnsNameResolverFactory getInstance() {
        return instance;
    }
}

