/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EquivalentAddressGroup {
    private final List<SocketAddress> addrs;

    public EquivalentAddressGroup(List<SocketAddress> addrs) {
        Preconditions.checkArgument(!addrs.isEmpty(), "addrs is empty");
        this.addrs = Collections.unmodifiableList(new ArrayList<SocketAddress>(addrs));
    }

    public EquivalentAddressGroup(SocketAddress addr) {
        this.addrs = Collections.singletonList(addr);
    }

    public List<SocketAddress> getAddresses() {
        return this.addrs;
    }

    public String toString() {
        return this.addrs.toString();
    }

    public int hashCode() {
        return this.addrs.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EquivalentAddressGroup)) {
            return false;
        }
        return this.addrs.equals(((EquivalentAddressGroup)other).addrs);
    }
}

