/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Charsets;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Metadata {
    public static final String BINARY_HEADER_SUFFIX = "-bin";
    public static final BinaryMarshaller<byte[]> BINARY_BYTE_MARSHALLER = new BinaryMarshaller<byte[]>(){

        @Override
        public byte[] toBytes(byte[] value) {
            return value;
        }

        @Override
        public byte[] parseBytes(byte[] serialized) {
            return serialized;
        }
    };
    public static final AsciiMarshaller<String> ASCII_STRING_MARSHALLER = new AsciiMarshaller<String>(){

        @Override
        public String toAsciiString(String value) {
            return value;
        }

        @Override
        public String parseAsciiString(String serialized) {
            return serialized;
        }
    };
    static final AsciiMarshaller<Integer> INTEGER_MARSHALLER = new AsciiMarshaller<Integer>(){

        @Override
        public String toAsciiString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer parseAsciiString(String serialized) {
            return Integer.parseInt(serialized);
        }
    };
    private final Map<String, List<MetadataEntry>> store = new LinkedHashMap<String, List<MetadataEntry>>();
    private int storeCount;

    public Metadata(byte[] ... binaryValues) {
        Preconditions.checkArgument(binaryValues.length % 2 == 0, "Odd number of key-value pairs: %s", binaryValues.length);
        for (int i = 0; i < binaryValues.length; i += 2) {
            String name = new String(binaryValues[i], Charsets.US_ASCII);
            this.storeAdd(name, new MetadataEntry(name.endsWith(BINARY_HEADER_SUFFIX), binaryValues[i + 1]));
        }
    }

    public Metadata() {
    }

    private void storeAdd(String name, MetadataEntry value) {
        List<MetadataEntry> values = this.store.get(name);
        if (values == null) {
            values = new ArrayList<MetadataEntry>(1);
            this.store.put(name, values);
        }
        ++this.storeCount;
        values.add(value);
    }

    public int headerCount() {
        return this.storeCount;
    }

    public boolean containsKey(Key<?> key) {
        return this.store.containsKey(key.name());
    }

    public <T> T get(Key<T> key) {
        List<MetadataEntry> values = this.store.get(key.name());
        if (values == null) {
            return null;
        }
        MetadataEntry metadataEntry = values.get(values.size() - 1);
        return metadataEntry.getParsed(key);
    }

    public <T> Iterable<T> getAll(final Key<T> key) {
        if (this.containsKey(key)) {
            return Iterables.unmodifiableIterable(Iterables.transform((Iterable)this.store.get(key.name()), new Function<MetadataEntry, T>(){

                @Override
                public T apply(MetadataEntry entry) {
                    return entry.getParsed(key);
                }
            }));
        }
        return null;
    }

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.store.keySet());
    }

    public <T> void put(Key<T> key, T value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.storeAdd(((Key)key).name, new MetadataEntry(key, value));
    }

    public <T> boolean remove(Key<T> key, T value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        List<MetadataEntry> values = this.store.get(key.name());
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            MetadataEntry entry = values.get(i);
            if (!value.equals(entry.getParsed(key))) continue;
            values.remove(i);
            --this.storeCount;
            return true;
        }
        return false;
    }

    public <T> Iterable<T> removeAll(final Key<T> key) {
        List<MetadataEntry> values = this.store.remove(key.name());
        if (values == null) {
            return null;
        }
        this.storeCount -= values.size();
        return Iterables.transform(values, new Function<MetadataEntry, T>(){

            @Override
            public T apply(MetadataEntry metadataEntry) {
                return metadataEntry.getParsed(key);
            }
        });
    }

    public byte[][] serialize() {
        byte[][] serialized = new byte[this.storeCount * 2][];
        int i = 0;
        for (Map.Entry<String, List<MetadataEntry>> storeEntry : this.store.entrySet()) {
            for (MetadataEntry metadataEntry : storeEntry.getValue()) {
                serialized[i++] = metadataEntry.key != null ? metadataEntry.key.asciiName() : storeEntry.getKey().getBytes(Charsets.US_ASCII);
                serialized[i++] = metadataEntry.getSerialized();
            }
        }
        return serialized;
    }

    public void merge(Metadata other) {
        Preconditions.checkNotNull(other);
        for (Map.Entry<String, List<MetadataEntry>> keyEntry : other.store.entrySet()) {
            for (int i = 0; i < keyEntry.getValue().size(); ++i) {
                this.storeAdd(keyEntry.getKey(), new MetadataEntry(keyEntry.getValue().get(i)));
            }
        }
    }

    public void merge(Metadata other, Set<Key<?>> keys) {
        Preconditions.checkNotNull(other);
        for (Key<?> key : keys) {
            List<MetadataEntry> values = other.store.get(key.name());
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                this.storeAdd(key.name(), new MetadataEntry(values.get(i)));
            }
        }
    }

    public String toString() {
        return "Metadata(" + this.toStringInternal() + ")";
    }

    private String toStringInternal() {
        return this.store.toString();
    }

    private static class MetadataEntry {
        Object parsed;
        Key key;
        boolean isBinary;
        byte[] serializedBinary;

        private MetadataEntry(Key<?> key, Object parsed) {
            this.parsed = Preconditions.checkNotNull(parsed);
            this.key = Preconditions.checkNotNull(key);
            this.isBinary = key instanceof BinaryKey;
        }

        private MetadataEntry(boolean isBinary, byte[] serialized) {
            Preconditions.checkNotNull(serialized);
            this.serializedBinary = serialized;
            this.isBinary = isBinary;
        }

        private MetadataEntry(MetadataEntry entry) {
            this.parsed = entry.parsed;
            this.key = entry.key;
            this.isBinary = entry.isBinary;
            this.serializedBinary = entry.serializedBinary;
        }

        public <T> T getParsed(Key<T> key) {
            Object value = this.parsed;
            if (value != null) {
                if (this.key != key) {
                    this.serializedBinary = this.key.toBytes(value);
                } else {
                    return (T)value;
                }
            }
            this.key = key;
            if (this.serializedBinary != null) {
                value = key.parseBytes(this.serializedBinary);
            }
            this.parsed = value;
            return (T)value;
        }

        public byte[] getSerialized() {
            this.serializedBinary = this.serializedBinary == null ? this.key.toBytes(this.parsed) : this.serializedBinary;
            return this.serializedBinary;
        }

        public String toString() {
            if (!this.isBinary) {
                return new String(this.getSerialized(), Charsets.US_ASCII);
            }
            if (this.parsed != null) {
                return "" + this.parsed;
            }
            return Arrays.toString(this.serializedBinary);
        }
    }

    private static class AsciiKey<T>
    extends Key<T> {
        private final AsciiMarshaller<T> marshaller;

        private AsciiKey(String name, AsciiMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument(!name.endsWith(Metadata.BINARY_HEADER_SUFFIX), "ASCII header is named %s. It must not end with %s", name, Metadata.BINARY_HEADER_SUFFIX);
            this.marshaller = Preconditions.checkNotNull(marshaller);
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toAsciiString(value).getBytes(Charsets.US_ASCII);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseAsciiString(new String(serialized, Charsets.US_ASCII));
        }
    }

    private static class BinaryKey<T>
    extends Key<T> {
        private final BinaryMarshaller<T> marshaller;

        private BinaryKey(String name, BinaryMarshaller<T> marshaller) {
            super(name);
            Preconditions.checkArgument(name.endsWith(Metadata.BINARY_HEADER_SUFFIX), "Binary header is named %s. It must end with %s", name, Metadata.BINARY_HEADER_SUFFIX);
            Preconditions.checkArgument(name.length() > Metadata.BINARY_HEADER_SUFFIX.length(), "empty key name");
            this.marshaller = Preconditions.checkNotNull(marshaller, "marshaller is null");
        }

        @Override
        byte[] toBytes(T value) {
            return this.marshaller.toBytes(value);
        }

        @Override
        T parseBytes(byte[] serialized) {
            return this.marshaller.parseBytes(serialized);
        }
    }

    public static abstract class Key<T> {
        private static final BitSet VALID_T_CHARS = Key.generateValidTChars();
        private final String originalName;
        private final String name;
        private final byte[] nameBytes;

        public static <T> Key<T> of(String name, BinaryMarshaller<T> marshaller) {
            return new BinaryKey(name, marshaller);
        }

        public static <T> Key<T> of(String name, AsciiMarshaller<T> marshaller) {
            return new AsciiKey(name, marshaller);
        }

        private static BitSet generateValidTChars() {
            int c;
            BitSet valid = new BitSet(127);
            valid.set(45);
            valid.set(95);
            valid.set(46);
            for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
                valid.set(c);
            }
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                valid.set(c);
            }
            return valid;
        }

        private static String validateName(String n) {
            Preconditions.checkNotNull(n);
            Preconditions.checkArgument(n.length() != 0, "token must have at least 1 tchar");
            for (int i = 0; i < n.length(); ++i) {
                char tChar = n.charAt(i);
                if (tChar == ':' && i == 0) continue;
                Preconditions.checkArgument(VALID_T_CHARS.get(tChar), "Invalid character '%s' in key name '%s'", Character.valueOf(tChar), n);
            }
            return n;
        }

        private Key(String name) {
            this.originalName = Preconditions.checkNotNull(name);
            this.name = Key.validateName(this.originalName.toLowerCase(Locale.ROOT)).intern();
            this.nameBytes = this.name.getBytes(Charsets.US_ASCII);
        }

        public final String originalName() {
            return this.originalName;
        }

        public final String name() {
            return this.name;
        }

        @VisibleForTesting
        byte[] asciiName() {
            return this.nameBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Key{name='" + this.name + "'}";
        }

        abstract byte[] toBytes(T var1);

        abstract T parseBytes(byte[] var1);
    }

    public static interface AsciiMarshaller<T> {
        public String toAsciiString(T var1);

        public T parseAsciiString(String var1);
    }

    public static interface BinaryMarshaller<T> {
        public byte[] toBytes(T var1);

        public T parseBytes(byte[] var1);
    }
}

