/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.MutableHandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.ServerMethodDefinition;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MutableHandlerRegistryImpl
extends MutableHandlerRegistry {
    private final ConcurrentMap<String, ServerServiceDefinition> services = new ConcurrentHashMap<String, ServerServiceDefinition>();

    @Override
    @Nullable
    public ServerServiceDefinition addService(ServerServiceDefinition service) {
        return this.services.put(service.getName(), service);
    }

    @Override
    public boolean removeService(ServerServiceDefinition service) {
        return this.services.remove(service.getName(), service);
    }

    @Override
    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        String serviceName = MethodDescriptor.extractFullServiceName(methodName);
        if (serviceName == null) {
            return null;
        }
        ServerServiceDefinition service = (ServerServiceDefinition)this.services.get(serviceName);
        if (service == null) {
            return null;
        }
        return service.getMethod(methodName);
    }
}

