/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.net.SocketAddress;
import javax.net.ssl.SSLSession;

public abstract class ServerCall<RespT> {
    public static final Attributes.Key<SocketAddress> REMOTE_ADDR_KEY = Attributes.Key.of("remote-addr");
    public static final Attributes.Key<SSLSession> SSL_SESSION_KEY = Attributes.Key.of("ssl-session");

    public abstract void request(int var1);

    public abstract void sendHeaders(Metadata var1);

    public abstract void sendMessage(RespT var1);

    public boolean isReady() {
        return true;
    }

    public abstract void close(Status var1, Metadata var2);

    public abstract boolean isCancelled();

    public void setMessageCompression(boolean enabled) {
    }

    public void setCompression(String compressor) {
    }

    public Attributes attributes() {
        return Attributes.EMPTY;
    }

    public static abstract class Listener<ReqT> {
        public void onMessage(ReqT message) {
        }

        public void onHalfClose() {
        }

        public void onCancel() {
        }

        public void onComplete() {
        }

        public void onReady() {
        }
    }
}

