/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerCallHandler;
import com.google.bigtable.repackaged.io.grpc.ServerMethodDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ServerServiceDefinition {
    private final String name;
    private final ImmutableMap<String, ServerMethodDefinition<?, ?>> methods;

    public static Builder builder(String serviceName) {
        return new Builder(serviceName);
    }

    private ServerServiceDefinition(String name, Map<String, ServerMethodDefinition<?, ?>> methods) {
        this.name = Preconditions.checkNotNull(name);
        this.methods = ImmutableMap.copyOf(methods);
    }

    public String getName() {
        return this.name;
    }

    public Collection<ServerMethodDefinition<?, ?>> getMethods() {
        return this.methods.values();
    }

    ServerMethodDefinition<?, ?> getMethod(String name) {
        return this.methods.get(name);
    }

    public static final class Builder {
        private final String serviceName;
        private final Map<String, ServerMethodDefinition<?, ?>> methods = new HashMap();

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public <ReqT, RespT> Builder addMethod(MethodDescriptor<ReqT, RespT> method, ServerCallHandler<ReqT, RespT> handler) {
            return this.addMethod(ServerMethodDefinition.create(Preconditions.checkNotNull(method, "method must not be null"), Preconditions.checkNotNull(handler, "handler must not be null")));
        }

        public <ReqT, RespT> Builder addMethod(ServerMethodDefinition<ReqT, RespT> def) {
            MethodDescriptor<ReqT, RespT> method = def.getMethodDescriptor();
            Preconditions.checkArgument(this.serviceName.equals(MethodDescriptor.extractFullServiceName(method.getFullMethodName())), "Service name mismatch. Expected service name: '%s'. Actual method name: '%s'.", this.serviceName, method.getFullMethodName());
            String name = method.getFullMethodName();
            Preconditions.checkState(!this.methods.containsKey(name), "Method by same name already registered: %s", name);
            this.methods.put(name, def);
            return this;
        }

        public ServerServiceDefinition build() {
            return new ServerServiceDefinition(this.serviceName, this.methods);
        }
    }
}

