/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfo;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.TransportManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class SimpleLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final SimpleLoadBalancerFactory instance = new SimpleLoadBalancerFactory();

    private SimpleLoadBalancerFactory() {
    }

    public static SimpleLoadBalancerFactory getInstance() {
        return instance;
    }

    @Override
    public <T> LoadBalancer<T> newLoadBalancer(String serviceName, TransportManager<T> tm) {
        return new SimpleLoadBalancer(tm);
    }

    private static class SimpleLoadBalancer<T>
    extends LoadBalancer<T> {
        private static final Status SHUTDOWN_STATUS = Status.UNAVAILABLE.augmentDescription("SimpleLoadBalancer has shut down");
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private EquivalentAddressGroup addresses;
        @GuardedBy(value="lock")
        private TransportManager.InterimTransport<T> interimTransport;
        @GuardedBy(value="lock")
        private Status nameResolutionError;
        @GuardedBy(value="lock")
        private boolean closed;
        private final TransportManager<T> tm;

        private SimpleLoadBalancer(TransportManager<T> tm) {
            this.tm = tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pickTransport(Attributes affinity) {
            EquivalentAddressGroup addressesCopy;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return this.tm.createFailingTransport(SHUTDOWN_STATUS);
                }
                addressesCopy = this.addresses;
                if (addressesCopy == null) {
                    if (this.nameResolutionError != null) {
                        return this.tm.createFailingTransport(this.nameResolutionError);
                    }
                    if (this.interimTransport == null) {
                        this.interimTransport = this.tm.createInterimTransport();
                    }
                    return this.interimTransport.transport();
                }
            }
            return this.tm.getTransport(addressesCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResolvedAddresses(List<ResolvedServerInfo> updatedServers, Attributes config) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            EquivalentAddressGroup newAddresses;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                ArrayList<SocketAddress> newAddressList = new ArrayList<SocketAddress>(updatedServers.size());
                for (ResolvedServerInfo server : updatedServers) {
                    newAddressList.add(server.getAddress());
                }
                newAddresses = new EquivalentAddressGroup(newAddressList);
                if (newAddresses.equals(this.addresses)) {
                    return;
                }
                this.addresses = newAddresses;
                this.nameResolutionError = null;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithRealTransports(new Supplier<T>(){

                    @Override
                    public T get() {
                        return SimpleLoadBalancer.this.tm.getTransport(newAddresses);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNameResolutionError(Status error) {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                error = error.augmentDescription("Name resolution failed");
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
                this.nameResolutionError = error;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            TransportManager.InterimTransport<T> savedInterimTransport;
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                savedInterimTransport = this.interimTransport;
                this.interimTransport = null;
            }
            if (savedInterimTransport != null) {
                savedInterimTransport.closeWithError(SHUTDOWN_STATUS);
            }
        }
    }
}

