/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.inprocess;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.inprocess.InProcessServer;
import com.google.bigtable.repackaged.io.grpc.inprocess.InProcessSocketAddress;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.NoopClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStream;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class InProcessTransport
implements ServerTransport,
ManagedClientTransport {
    private static final Logger log = Logger.getLogger(InProcessTransport.class.getName());
    private final String name;
    private ServerTransportListener serverTransportListener;
    private final Attributes serverStreamAttributes;
    private ManagedClientTransport.Listener clientTransportListener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;
    @GuardedBy(value="this")
    private Status shutdownStatus;
    @GuardedBy(value="this")
    private Set<InProcessStream> streams = new HashSet<InProcessStream>();

    public InProcessTransport(String name) {
        this.name = name;
        this.serverStreamAttributes = Attributes.newBuilder().set(ServerCall.REMOTE_ADDR_KEY, new InProcessSocketAddress(name)).build();
    }

    @Override
    public synchronized void start(ManagedClientTransport.Listener listener) {
        this.clientTransportListener = listener;
        InProcessServer server = InProcessServer.findServer(this.name);
        if (server != null) {
            this.serverTransportListener = server.register(this);
        }
        if (this.serverTransportListener == null) {
            final Status localShutdownStatus = this.shutdownStatus = Status.UNAVAILABLE.withDescription("Could not find server: " + this.name);
            Thread shutdownThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InProcessTransport inProcessTransport = InProcessTransport.this;
                    synchronized (inProcessTransport) {
                        InProcessTransport.this.notifyShutdown(localShutdownStatus);
                        InProcessTransport.this.notifyTerminated();
                    }
                }
            });
            shutdownThread.setDaemon(true);
            shutdownThread.setName("grpc-inprocess-shutdown");
            shutdownThread.start();
            return;
        }
        Thread readyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    InProcessTransport.this.clientTransportListener.transportReady();
                }
            }
        });
        readyThread.setDaemon(true);
        readyThread.setName("grpc-inprocess-ready");
        readyThread.start();
    }

    @Override
    public synchronized ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        if (this.shutdownStatus != null) {
            final Status capturedStatus = this.shutdownStatus;
            return new NoopClientStream(){

                @Override
                public void start(ClientStreamListener listener) {
                    listener.closed(capturedStatus, new Metadata());
                }
            };
        }
        return new InProcessStream(method, headers).clientStream;
    }

    @Override
    public synchronized void ping(final ClientTransport.PingCallback callback, Executor executor) {
        if (this.terminated) {
            final Status shutdownStatus = this.shutdownStatus;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(shutdownStatus.asRuntimeException());
                }
            });
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(0L);
                }
            });
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdownStatus = Status.UNAVAILABLE.withDescription("transport was requested to shut down");
        this.notifyShutdown(this.shutdownStatus);
        if (this.streams.isEmpty()) {
            this.notifyTerminated();
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.name + ")";
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    private synchronized void notifyShutdown(Status s) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.clientTransportListener.transportShutdown(s);
    }

    private synchronized void notifyTerminated() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.clientTransportListener.transportTerminated();
        if (this.serverTransportListener != null) {
            this.serverTransportListener.transportTerminated();
        }
    }

    private class InProcessStream {
        private final InProcessServerStream serverStream = new InProcessServerStream();
        private final InProcessClientStream clientStream = new InProcessClientStream();
        private final Metadata headers;
        private MethodDescriptor<?, ?> method;

        private InProcessStream(MethodDescriptor<?, ?> method, Metadata headers) {
            this.method = Preconditions.checkNotNull(method);
            this.headers = Preconditions.checkNotNull(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamClosed() {
            InProcessTransport inProcessTransport = InProcessTransport.this;
            synchronized (inProcessTransport) {
                boolean justRemovedAnElement = InProcessTransport.this.streams.remove(this);
                if (InProcessTransport.this.shutdown && InProcessTransport.this.streams.isEmpty() && justRemovedAnElement) {
                    InProcessTransport.this.notifyTerminated();
                }
            }
        }

        private class InProcessClientStream
        implements ClientStream {
            @GuardedBy(value="this")
            private ServerStreamListener serverStreamListener;
            @GuardedBy(value="this")
            private int serverRequested;
            @GuardedBy(value="this")
            private ArrayDeque<InputStream> serverReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private boolean serverNotifyHalfClose;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessClientStream() {
            }

            private synchronized void setListener(ServerStreamListener listener) {
                this.serverStreamListener = listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.serverStream.clientRequested(numMessages);
                if (onReady) {
                    InProcessClientStream inProcessClientStream = this;
                    synchronized (inProcessClientStream) {
                        if (!this.closed) {
                            this.serverStreamListener.onReady();
                        }
                    }
                }
            }

            private synchronized boolean serverRequested(int numMessages) {
                if (this.closed) {
                    return false;
                }
                boolean previouslyReady = this.serverRequested > 0;
                this.serverRequested += numMessages;
                while (this.serverRequested > 0 && !this.serverReceiveQueue.isEmpty()) {
                    --this.serverRequested;
                    this.serverStreamListener.messageRead(this.serverReceiveQueue.poll());
                }
                if (this.serverReceiveQueue.isEmpty() && this.serverNotifyHalfClose) {
                    this.serverNotifyHalfClose = false;
                    this.serverStreamListener.halfClosed();
                }
                boolean nowReady = this.serverRequested > 0;
                return !previouslyReady && nowReady;
            }

            private void serverClosed(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                if (this.serverRequested > 0) {
                    --this.serverRequested;
                    this.serverStreamListener.messageRead(message);
                } else {
                    this.serverReceiveQueue.add(message);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.serverRequested > 0;
            }

            @Override
            public void cancel(Status reason) {
                if (!this.internalCancel(reason)) {
                    return;
                }
                InProcessStream.this.serverStream.clientCancelled(reason);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status reason) {
                InputStream stream;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((stream = this.serverReceiveQueue.poll()) != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Exception closing stream", t);
                    }
                }
                this.serverStreamListener.closed(reason);
                return true;
            }

            @Override
            public synchronized void halfClose() {
                if (this.closed) {
                    return;
                }
                if (this.serverReceiveQueue.isEmpty()) {
                    this.serverStreamListener.halfClosed();
                } else {
                    this.serverNotifyHalfClose = true;
                }
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void setAuthority(String string) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(ClientStreamListener listener) {
                InProcessStream.this.serverStream.setListener(listener);
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    ServerStreamListener serverStreamListener = InProcessTransport.this.serverTransportListener.streamCreated(InProcessStream.this.serverStream, InProcessStream.this.method.getFullMethodName(), InProcessStream.this.headers);
                    InProcessStream.this.clientStream.setListener(serverStreamListener);
                    InProcessTransport.this.streams.add(InProcessStream.this);
                }
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setDecompressor(Decompressor decompressor) {
            }
        }

        private class InProcessServerStream
        implements ServerStream {
            @GuardedBy(value="this")
            private ClientStreamListener clientStreamListener;
            @GuardedBy(value="this")
            private int clientRequested;
            @GuardedBy(value="this")
            private ArrayDeque<InputStream> clientReceiveQueue = new ArrayDeque();
            @GuardedBy(value="this")
            private Status clientNotifyStatus;
            @GuardedBy(value="this")
            private Metadata clientNotifyTrailers;
            @GuardedBy(value="this")
            private boolean closed;

            private InProcessServerStream() {
            }

            private synchronized void setListener(ClientStreamListener listener) {
                this.clientStreamListener = listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.clientStream.serverRequested(numMessages);
                if (onReady) {
                    InProcessServerStream inProcessServerStream = this;
                    synchronized (inProcessServerStream) {
                        if (!this.closed) {
                            this.clientStreamListener.onReady();
                        }
                    }
                }
            }

            private synchronized boolean clientRequested(int numMessages) {
                if (this.closed) {
                    return false;
                }
                boolean previouslyReady = this.clientRequested > 0;
                this.clientRequested += numMessages;
                while (this.clientRequested > 0 && !this.clientReceiveQueue.isEmpty()) {
                    --this.clientRequested;
                    this.clientStreamListener.messageRead(this.clientReceiveQueue.poll());
                }
                if (this.closed) {
                    return false;
                }
                if (this.clientReceiveQueue.isEmpty() && this.clientNotifyStatus != null) {
                    this.closed = true;
                    this.clientStreamListener.closed(this.clientNotifyStatus, this.clientNotifyTrailers);
                }
                boolean nowReady = this.clientRequested > 0;
                return !previouslyReady && nowReady;
            }

            private void clientCancelled(Status status) {
                this.internalCancel(status);
            }

            @Override
            public synchronized void writeMessage(InputStream message) {
                if (this.closed) {
                    return;
                }
                if (this.clientRequested > 0) {
                    --this.clientRequested;
                    this.clientStreamListener.messageRead(message);
                } else {
                    this.clientReceiveQueue.add(message);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.clientRequested > 0;
            }

            @Override
            public synchronized void writeHeaders(Metadata headers) {
                if (this.closed) {
                    return;
                }
                this.clientStreamListener.headersRead(headers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close(Status status, Metadata trailers) {
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    if (this.clientReceiveQueue.isEmpty()) {
                        this.closed = true;
                        this.clientStreamListener.closed(status, trailers);
                    } else {
                        this.clientNotifyStatus = status;
                        this.clientNotifyTrailers = trailers;
                    }
                }
                InProcessStream.this.clientStream.serverClosed(Status.OK);
                InProcessStream.this.streamClosed();
            }

            @Override
            public void cancel(Status status) {
                if (!this.internalCancel(Status.CANCELLED.withDescription("server cancelled stream"))) {
                    return;
                }
                InProcessStream.this.clientStream.serverClosed(status);
                InProcessStream.this.streamClosed();
            }

            private synchronized boolean internalCancel(Status status) {
                InputStream stream;
                if (this.closed) {
                    return false;
                }
                this.closed = true;
                while ((stream = this.clientReceiveQueue.poll()) != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Exception closing stream", t);
                    }
                }
                this.clientStreamListener.closed(status, new Metadata());
                return true;
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setDecompressor(Decompressor decompressor) {
            }

            @Override
            public Attributes attributes() {
                return InProcessTransport.this.serverStreamAttributes;
            }
        }
    }
}

