/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.BindableService;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.MutableHandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.MutableHandlerRegistryImpl;
import com.google.bigtable.repackaged.io.grpc.ServerBuilder;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import com.google.bigtable.repackaged.io.grpc.internal.InternalServer;
import com.google.bigtable.repackaged.io.grpc.internal.ServerImpl;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private final HandlerRegistry registry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractServerImplBuilder(HandlerRegistry registry) {
        this.registry = Preconditions.checkNotNull(registry);
    }

    protected AbstractServerImplBuilder() {
        this.registry = new MutableHandlerRegistryImpl();
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        if (this.registry instanceof MutableHandlerRegistry) {
            ((MutableHandlerRegistry)this.registry).addService(service);
            return this.thisT();
        }
        throw new UnsupportedOperationException("Underlying HandlerRegistry is not mutable");
    }

    @Override
    public final T addService(BindableService bindableService) {
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        InternalServer transportServer = this.buildTransportServer();
        return new ServerImpl(this.executor, this.registry, transportServer, Context.ROOT, MoreObjects.firstNonNull(this.decompressorRegistry, DecompressorRegistry.getDefaultInstance()), MoreObjects.firstNonNull(this.compressorRegistry, CompressorRegistry.getDefaultInstance()));
    }

    protected abstract InternalServer buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

