/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.com.google.common.base.Suppliers;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.DelayedStream;
import com.google.bigtable.repackaged.io.grpc.internal.FailingClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedClientTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class DelayedClientTransport
implements ManagedClientTransport {
    private final Object lock = new Object();
    private final Executor streamCreationExecutor;
    private ManagedClientTransport.Listener listener;
    private volatile Supplier<ClientTransport> transportSupplier;
    @GuardedBy(value="lock")
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    @GuardedBy(value="lock")
    private Collection<PendingPing> pendingPings = new ArrayList<PendingPing>();
    @GuardedBy(value="lock")
    private boolean shutdown;

    DelayedClientTransport(Executor streamCreationExecutor) {
        this.streamCreationExecutor = streamCreationExecutor;
    }

    @Override
    public void start(ManagedClientTransport.Listener listener) {
        this.listener = Preconditions.checkNotNull(listener, "listener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        Supplier<ClientTransport> supplier = this.transportSupplier;
        if (supplier == null) {
            Object object = this.lock;
            synchronized (object) {
                supplier = this.transportSupplier;
                if (supplier == null && !this.shutdown) {
                    PendingStream pendingStream = new PendingStream(method, headers);
                    this.pendingStreams.add(pendingStream);
                    return pendingStream;
                }
            }
        }
        if (supplier != null) {
            return supplier.get().newStream(method, headers);
        }
        return new FailingClientStream(Status.UNAVAILABLE.withDescription("transport shutdown"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        Supplier<ClientTransport> supplier = this.transportSupplier;
        if (supplier == null) {
            Object object = this.lock;
            synchronized (object) {
                supplier = this.transportSupplier;
                if (supplier == null && !this.shutdown) {
                    PendingPing pendingPing = new PendingPing(callback, executor);
                    this.pendingPings.add(pendingPing);
                    return;
                }
            }
        }
        if (supplier != null) {
            supplier.get().ping(callback, executor);
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(Status.UNAVAILABLE.withDescription("transport shutdown").asException());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.listener.transportShutdown(Status.UNAVAILABLE.withDescription("Channel requested transport to shut down"));
            if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
                this.pendingStreams = null;
                this.listener.transportTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Status status) {
        this.shutdown();
        Collection<PendingStream> savedPendingStreams = null;
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            if (this.pendingStreams != null) {
                savedPendingStreams = this.pendingStreams;
                this.pendingStreams = null;
            }
        }
        if (savedPendingStreams != null) {
            for (PendingStream stream : savedPendingStreams) {
                stream.cancel(status);
            }
            this.listener.transportTerminated();
        }
    }

    public void setTransport(ClientTransport transport) {
        this.setTransportSupplier(Suppliers.ofInstance(transport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportSupplier(final Supplier<ClientTransport> supplier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.transportSupplier != null) {
                return;
            }
            Preconditions.checkState(this.listener != null, "start() not called");
            this.transportSupplier = Preconditions.checkNotNull(supplier, "supplier");
            for (PendingPing ping : this.pendingPings) {
                ping.createRealPing(supplier.get());
            }
            this.pendingPings = null;
            if (this.shutdown && this.pendingStreams != null) {
                this.listener.transportTerminated();
            }
            if (this.pendingStreams != null && !this.pendingStreams.isEmpty()) {
                final Collection<PendingStream> savedPendingStreams = this.pendingStreams;
                this.streamCreationExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (PendingStream stream : savedPendingStreams) {
                            stream.createRealStream((ClientTransport)supplier.get());
                        }
                    }
                });
            }
            this.pendingStreams = null;
            if (!this.shutdown) {
                this.listener.transportReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams == null ? 0 : this.pendingStreams.size();
        }
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    @Nullable
    @VisibleForTesting
    Supplier<ClientTransport> getTransportSupplier() {
        return this.transportSupplier;
    }

    private static class PendingPing {
        private final ClientTransport.PingCallback callback;
        private final Executor executor;

        public PendingPing(ClientTransport.PingCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        public void createRealPing(ClientTransport transport) {
            try {
                transport.ping(this.callback, this.executor);
            }
            catch (UnsupportedOperationException ex) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PendingPing.this.callback.onFailure(ex);
                    }
                });
            }
        }
    }

    private class PendingStream
    extends DelayedStream {
        private final MethodDescriptor<?, ?> method;
        private final Metadata headers;

        private PendingStream(MethodDescriptor<?, ?> method, Metadata headers) {
            this.method = method;
            this.headers = headers;
        }

        private void createRealStream(ClientTransport transport) {
            this.setStream(transport.newStream(this.method, this.headers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(Status reason) {
            super.cancel(reason);
            Object object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.pendingStreams != null) {
                    DelayedClientTransport.this.pendingStreams.remove(this);
                    if (DelayedClientTransport.this.shutdown && DelayedClientTransport.this.pendingStreams.isEmpty()) {
                        DelayedClientTransport.this.pendingStreams = null;
                        DelayedClientTransport.this.listener.transportTerminated();
                    }
                }
            }
        }
    }
}

