/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

final class ExponentialBackoffPolicy
implements BackoffPolicy {
    private Random random = new Random();
    private long initialBackoffMillis = TimeUnit.SECONDS.toMillis(1L);
    private long maxBackoffMillis = TimeUnit.MINUTES.toMillis(2L);
    private double multiplier = 1.6;
    private double jitter = 0.2;
    private long nextBackoffMillis = this.initialBackoffMillis;

    ExponentialBackoffPolicy() {
    }

    @Override
    public long nextBackoffMillis() {
        long currentBackoffMillis = this.nextBackoffMillis;
        this.nextBackoffMillis = Math.min((long)((double)currentBackoffMillis * this.multiplier), this.maxBackoffMillis);
        return currentBackoffMillis + this.uniformRandom(-this.jitter * (double)currentBackoffMillis, this.jitter * (double)currentBackoffMillis);
    }

    private long uniformRandom(double low, double high) {
        Preconditions.checkArgument(high >= low);
        double mag = high - low;
        return (long)(this.random.nextDouble() * mag + low);
    }

    @VisibleForTesting
    ExponentialBackoffPolicy setRandom(Random random) {
        this.random = random;
        return this;
    }

    @VisibleForTesting
    ExponentialBackoffPolicy setInitialBackoffMillis(long initialBackoffMillis) {
        this.initialBackoffMillis = initialBackoffMillis;
        return this;
    }

    @VisibleForTesting
    ExponentialBackoffPolicy setMaxBackoffMillis(long maxBackoffMillis) {
        this.maxBackoffMillis = maxBackoffMillis;
        return this;
    }

    @VisibleForTesting
    ExponentialBackoffPolicy setMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @VisibleForTesting
    ExponentialBackoffPolicy setJitter(double jitter) {
        this.jitter = jitter;
        return this;
    }

    static final class Provider
    implements BackoffPolicy.Provider {
        Provider() {
        }

        @Override
        public BackoffPolicy get() {
            return new ExponentialBackoffPolicy();
        }
    }
}

