/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Charsets;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractStream;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.ReadableBuffers;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBufferAllocator;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public abstract class Http2ClientStream
extends AbstractClientStream<Integer> {
    private static final Metadata.AsciiMarshaller<Integer> HTTP_STATUS_LINE_MARSHALLER = new Metadata.AsciiMarshaller<Integer>(){

        @Override
        public String toAsciiString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer parseAsciiString(String serialized) {
            return Integer.parseInt(serialized.split(" ", 2)[0]);
        }
    };
    private static final Metadata.Key<Integer> HTTP2_STATUS = Metadata.Key.of(":status", HTTP_STATUS_LINE_MARSHALLER);
    private Status transportError;
    private Metadata transportErrorMetadata;
    private Charset errorCharset = Charsets.UTF_8;
    private boolean contentTypeChecked;

    protected Http2ClientStream(WritableBufferAllocator bufferAllocator, int maxMessageSize) {
        super(bufferAllocator, maxMessageSize);
    }

    protected void transportHeadersReceived(Metadata headers) {
        Preconditions.checkNotNull(headers);
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription(headers.toString());
            return;
        }
        Status httpStatus = Http2ClientStream.statusFromHttpStatus(headers);
        this.transportError = httpStatus == null ? Status.INTERNAL.withDescription("received non-terminal headers with no :status") : (!httpStatus.isOk() ? httpStatus : this.checkContentType(headers));
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("\n" + headers);
            this.transportErrorMetadata = headers;
            this.errorCharset = Http2ClientStream.extractCharset(headers);
        } else {
            Http2ClientStream.stripTransportDetails(headers);
            this.inboundHeadersReceived(headers);
        }
    }

    protected void transportDataReceived(ReadableBuffer frame, boolean endOfStream) {
        if (this.transportError == null && this.inboundPhase() == AbstractStream.Phase.HEADERS) {
            this.transportError = Status.INTERNAL.withDescription("no headers received prior to data");
            this.transportErrorMetadata = new Metadata();
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("DATA-----------------------------\n" + ReadableBuffers.readAsString(frame, this.errorCharset));
            frame.close();
            if (this.transportError.getDescription().length() > 1000 || endOfStream) {
                this.inboundTransportError(this.transportError, this.transportErrorMetadata);
                this.sendCancel(Status.CANCELLED);
            }
        } else {
            this.inboundDataReceived(frame);
            if (endOfStream) {
                this.transportError = Status.INTERNAL.withDescription("Received EOS on DATA frame");
                this.transportErrorMetadata = new Metadata();
                this.inboundTransportError(this.transportError, this.transportErrorMetadata);
            }
        }
    }

    protected void transportTrailersReceived(Metadata trailers) {
        Preconditions.checkNotNull(trailers);
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription(trailers.toString());
        } else {
            this.transportError = this.checkContentType(trailers);
            this.transportErrorMetadata = trailers;
        }
        if (this.transportError != null) {
            this.inboundTransportError(this.transportError, this.transportErrorMetadata);
            this.sendCancel(Status.CANCELLED);
        } else {
            Status status = this.statusFromTrailers(trailers);
            Http2ClientStream.stripTransportDetails(trailers);
            this.inboundTrailersReceived(trailers, status);
        }
    }

    private static Status statusFromHttpStatus(Metadata metadata) {
        Integer httpStatus = metadata.get(HTTP2_STATUS);
        if (httpStatus != null) {
            Status status = GrpcUtil.httpStatusToGrpcStatus(httpStatus);
            return status.isOk() ? status : status.augmentDescription("extracted status from HTTP :status " + httpStatus);
        }
        return null;
    }

    private Status statusFromTrailers(Metadata trailers) {
        String message;
        Status status = trailers.get(Status.CODE_KEY);
        if (status == null) {
            status = Http2ClientStream.statusFromHttpStatus(trailers);
            status = status == null || status.isOk() ? Status.UNKNOWN.withDescription("missing GRPC status in response") : status.withDescription("missing GRPC status, inferred error from HTTP status code");
        }
        if ((message = trailers.get(Status.MESSAGE_KEY)) != null) {
            status = status.augmentDescription(message);
        }
        return status;
    }

    @Nullable
    private Status checkContentType(Metadata headers) {
        if (this.contentTypeChecked) {
            return null;
        }
        this.contentTypeChecked = true;
        String contentType = headers.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (!GrpcUtil.isGrpcContentType(contentType)) {
            return Status.INTERNAL.withDescription("Invalid content-type: " + contentType);
        }
        return null;
    }

    private static Charset extractCharset(Metadata headers) {
        String contentType = headers.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (contentType != null) {
            String[] split = contentType.split("charset=");
            try {
                return Charset.forName(split[split.length - 1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charsets.UTF_8;
    }

    private static void stripTransportDetails(Metadata metadata) {
        metadata.removeAll(HTTP2_STATUS);
        metadata.removeAll(Status.CODE_KEY);
        metadata.removeAll(Status.MESSAGE_KEY);
    }
}

