/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.io.ByteStreams;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.Drainable;
import com.google.bigtable.repackaged.io.grpc.KnownLength;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBufferAllocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageFramer {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private final Sink sink;
    private WritableBuffer buffer;
    private Compressor compressor = Codec.Identity.NONE;
    private boolean messageCompression;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final WritableBufferAllocator bufferAllocator;
    private boolean closed;

    public MessageFramer(Sink sink, WritableBufferAllocator bufferAllocator) {
        this.sink = Preconditions.checkNotNull(sink, "sink");
        this.bufferAllocator = Preconditions.checkNotNull(bufferAllocator, "bufferAllocator");
    }

    MessageFramer setCompressor(Compressor compressor) {
        this.compressor = Preconditions.checkNotNull(compressor, "Can't pass an empty compressor");
        return this;
    }

    MessageFramer setMessageCompression(boolean enable) {
        this.messageCompression = enable;
        return this;
    }

    public void writePayload(InputStream message) {
        this.verifyNotClosed();
        boolean compressed = this.messageCompression && this.compressor != Codec.Identity.NONE;
        int written = -1;
        int messageLength = -2;
        try {
            messageLength = this.getKnownLength(message);
            written = messageLength != 0 && compressed ? this.writeCompressed(message, messageLength) : this.writeUncompressed(message, messageLength);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withDescription("Failed to frame message").withCause(e).asRuntimeException();
        }
        catch (RuntimeException e) {
            throw Status.INTERNAL.withDescription("Failed to frame message").withCause(e).asRuntimeException();
        }
        if (messageLength != -1 && written != messageLength) {
            String err = String.format("Message length inaccurate %s != %s", written, messageLength);
            throw Status.INTERNAL.withDescription(err).asRuntimeException();
        }
    }

    private int writeUncompressed(InputStream message, int messageLength) throws IOException {
        if (messageLength != -1) {
            return this.writeKnownLength(message, messageLength, false);
        }
        BufferChainOutputStream bufferChain = new BufferChainOutputStream();
        int written = MessageFramer.writeToOutputStream(message, bufferChain);
        this.writeBufferChain(bufferChain, false);
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCompressed(InputStream message, int messageLength) throws IOException {
        int written;
        BufferChainOutputStream bufferChain = new BufferChainOutputStream();
        OutputStream compressingStream = this.compressor.compress(bufferChain);
        try {
            written = MessageFramer.writeToOutputStream(message, compressingStream);
        }
        finally {
            compressingStream.close();
        }
        this.writeBufferChain(bufferChain, true);
        return written;
    }

    private int getKnownLength(InputStream inputStream) throws IOException {
        if (inputStream instanceof KnownLength || inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        return -1;
    }

    private int writeKnownLength(InputStream message, int messageLength, boolean compressed) throws IOException {
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        header.putInt(messageLength);
        if (this.buffer == null) {
            this.buffer = this.bufferAllocator.allocate(header.position() + messageLength);
        }
        this.writeRaw(this.headerScratch, 0, header.position());
        return MessageFramer.writeToOutputStream(message, this.outputStreamAdapter);
    }

    private void writeBufferChain(BufferChainOutputStream bufferChain, boolean compressed) {
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        int messageLength = bufferChain.readableBytes();
        header.putInt(messageLength);
        WritableBuffer writeableHeader = this.bufferAllocator.allocate(5);
        writeableHeader.write(this.headerScratch, 0, header.position());
        if (messageLength == 0) {
            this.buffer = writeableHeader;
            return;
        }
        this.sink.deliverFrame(writeableHeader, false, false);
        List bufferList = bufferChain.bufferList;
        for (int i = 0; i < bufferList.size() - 1; ++i) {
            this.sink.deliverFrame((WritableBuffer)bufferList.get(i), false, false);
        }
        this.buffer = (WritableBuffer)bufferList.get(bufferList.size() - 1);
    }

    private static int writeToOutputStream(InputStream message, OutputStream outputStream) throws IOException {
        if (message instanceof Drainable) {
            return ((Drainable)((Object)message)).drainTo(outputStream);
        }
        long written = ByteStreams.copy(message, outputStream);
        Preconditions.checkArgument(written <= Integer.MAX_VALUE, "Message size overflow: %s", written);
        return (int)written;
    }

    private void writeRaw(byte[] b, int off, int len) {
        while (len > 0) {
            if (this.buffer != null && this.buffer.writableBytes() == 0) {
                this.commitToSink(false, false);
            }
            if (this.buffer == null) {
                this.buffer = this.bufferAllocator.allocate(len);
            }
            int toWrite = Math.min(len, this.buffer.writableBytes());
            this.buffer.write(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.commitToSink(false, true);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.readableBytes() == 0) {
                this.releaseBuffer();
            }
            this.commitToSink(true, true);
        }
    }

    public void dispose() {
        this.closed = true;
        this.releaseBuffer();
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean endOfStream, boolean flush) {
        WritableBuffer buf = this.buffer;
        this.buffer = null;
        this.sink.deliverFrame(buf, endOfStream, flush);
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    private final class BufferChainOutputStream
    extends OutputStream {
        private final List<WritableBuffer> bufferList = new ArrayList<WritableBuffer>();
        private WritableBuffer current;

        private BufferChainOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.current != null && this.current.writableBytes() > 0) {
                this.current.write((byte)b);
                return;
            }
            byte[] singleByte = new byte[]{(byte)b};
            this.write(singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.current == null) {
                this.current = MessageFramer.this.bufferAllocator.allocate(len);
                this.bufferList.add(this.current);
            }
            while (len > 0) {
                int canWrite = Math.min(len, this.current.writableBytes());
                if (canWrite == 0) {
                    int needed = Math.max(len, this.current.readableBytes() * 2);
                    this.current = MessageFramer.this.bufferAllocator.allocate(needed);
                    this.bufferList.add(this.current);
                    continue;
                }
                this.current.write(b, off, canWrite);
                off += canWrite;
                len -= canWrite;
            }
        }

        private int readableBytes() {
            int readable = 0;
            for (WritableBuffer writableBuffer : this.bufferList) {
                readable += writableBuffer.readableBytes();
            }
            return readable;
        }
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private final byte[] singleByte = new byte[1];

        private OutputStreamAdapter() {
        }

        @Override
        public void write(int b) {
            this.singleByte[0] = (byte)b;
            this.write(this.singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            MessageFramer.this.writeRaw(b, off, len);
        }
    }

    public static interface Sink {
        public void deliverFrame(WritableBuffer var1, boolean var2, boolean var3);
    }
}

