/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStream;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

final class ServerCallImpl<ReqT, RespT>
extends ServerCall<RespT> {
    private final ServerStream stream;
    private final MethodDescriptor<ReqT, RespT> method;
    private final Context.CancellableContext context;
    private Metadata inboundHeaders;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private Compressor compressor;

    ServerCallImpl(ServerStream stream, MethodDescriptor<ReqT, RespT> method, Metadata inboundHeaders, Context.CancellableContext context, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry) {
        this.stream = stream;
        this.method = method;
        this.context = context;
        this.inboundHeaders = inboundHeaders;
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        if (inboundHeaders.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
            String encoding = inboundHeaders.get(GrpcUtil.MESSAGE_ENCODING_KEY);
            Decompressor decompressor = decompressorRegistry.lookupDecompressor(encoding);
            if (decompressor == null) {
                throw Status.INTERNAL.withDescription(String.format("Can't find decompressor for %s", encoding)).asRuntimeException();
            }
            stream.setDecompressor(decompressor);
        }
    }

    @Override
    public void request(int numMessages) {
        this.stream.request(numMessages);
    }

    @Override
    public void sendHeaders(Metadata headers) {
        Object acceptEncodings;
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has already been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        headers.removeAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (this.compressor == null) {
            this.compressor = Codec.Identity.NONE;
            if (this.inboundHeaders.containsKey(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY)) {
                acceptEncodings = this.inboundHeaders.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
                for (String acceptEncoding : GrpcUtil.ACCEPT_ENCODING_SPLITER.split((CharSequence)acceptEncodings)) {
                    Compressor c = this.compressorRegistry.lookupCompressor(acceptEncoding);
                    if (c == null) continue;
                    this.compressor = c;
                    break;
                }
            }
        } else if (this.inboundHeaders.containsKey(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY)) {
            acceptEncodings = this.inboundHeaders.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
            List<String> acceptedEncodingsList = GrpcUtil.ACCEPT_ENCODING_SPLITER.splitToList((CharSequence)acceptEncodings);
            if (!acceptedEncodingsList.contains(this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        this.inboundHeaders = null;
        if (this.compressor != Codec.Identity.NONE) {
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, this.compressor.getMessageEncoding());
        }
        this.stream.setCompressor(this.compressor);
        headers.removeAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        acceptEncodings = this.decompressorRegistry.getAdvertisedMessageEncodings();
        if (!acceptEncodings.isEmpty()) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, GrpcUtil.ACCEPT_ENCODING_JOINER.join((Iterable<?>)acceptEncodings));
        }
        this.sendHeadersCalled = true;
        this.stream.writeHeaders(headers);
    }

    @Override
    public void sendMessage(RespT message) {
        Preconditions.checkState(this.sendHeadersCalled, "sendHeaders has not been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        try {
            InputStream resp = this.method.streamResponse(message);
            this.stream.writeMessage(resp);
            this.stream.flush();
        }
        catch (RuntimeException e) {
            this.close(Status.fromThrowable(e), new Metadata());
            throw e;
        }
        catch (Throwable t) {
            this.close(Status.fromThrowable(t), new Metadata());
            throw new RuntimeException(t);
        }
    }

    @Override
    public void setMessageCompression(boolean enable) {
        this.stream.setMessageCompression(enable);
    }

    @Override
    public void setCompression(String compressorName) {
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument(this.compressor != null, "Unable to find compressor by name %s", compressorName);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public void close(Status status, Metadata trailers) {
        Preconditions.checkState(!this.closeCalled, "call already closed");
        this.closeCalled = true;
        this.inboundHeaders = null;
        this.stream.close(status, trailers);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCall.Listener<ReqT> listener) {
        return new ServerStreamListenerImpl<ReqT>(this, listener, this.context);
    }

    @Override
    public Attributes attributes() {
        return this.stream.attributes();
    }

    @VisibleForTesting
    static final class ServerStreamListenerImpl<ReqT>
    implements ServerStreamListener {
        private final ServerCallImpl<ReqT, ?> call;
        private final ServerCall.Listener<ReqT> listener;
        private final Context.CancellableContext context;
        private boolean messageReceived;

        public ServerStreamListenerImpl(ServerCallImpl<ReqT, ?> call, ServerCall.Listener<ReqT> listener, Context.CancellableContext context) {
            this.call = Preconditions.checkNotNull(call, "call");
            this.listener = Preconditions.checkNotNull(listener, "listener must not be null");
            this.context = Preconditions.checkNotNull(context, "context");
        }

        @Override
        public void messageRead(InputStream message) {
            try {
                if (((ServerCallImpl)this.call).cancelled) {
                    return;
                }
                if (this.messageReceived && ((ServerCallImpl)this.call).method.getType() == MethodDescriptor.MethodType.UNARY) {
                    ((ServerCallImpl)this.call).stream.close(Status.INVALID_ARGUMENT.withDescription("More than one request messages for unary call or server streaming call"), new Metadata());
                    return;
                }
                this.messageReceived = true;
                this.listener.onMessage(((ServerCallImpl)this.call).method.parseRequest(message));
            }
            finally {
                try {
                    message.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void halfClosed() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onHalfClose();
        }

        @Override
        public void closed(Status status) {
            try {
                if (status.isOk()) {
                    this.listener.onComplete();
                } else {
                    ((ServerCallImpl)this.call).cancelled = true;
                    this.listener.onCancel();
                }
            }
            finally {
                this.context.cancel(null);
            }
        }

        @Override
        public void onReady() {
            if (((ServerCallImpl)this.call).cancelled) {
                return;
            }
            this.listener.onReady();
        }
    }
}

