/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.internal.ClientCallImpl;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.SerializingExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class SingleTransportChannel
extends Channel {
    private final ClientTransport transport;
    private final Executor executor;
    private final String authority;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(CallOptions callOptions) {
            return SingleTransportChannel.this.transport;
        }
    };

    public SingleTransportChannel(ClientTransport transport, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, String authority) {
        this.transport = Preconditions.checkNotNull(transport, "transport");
        this.executor = Preconditions.checkNotNull(executor, "executor");
        this.deadlineCancellationExecutor = Preconditions.checkNotNull(deadlineCancellationExecutor, "deadlineCancellationExecutor");
        this.authority = Preconditions.checkNotNull(authority, "authority");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, new SerializingExecutor(this.executor), callOptions, this.transportProvider, this.deadlineCancellationExecutor);
    }

    @Override
    public String authority() {
        return this.authority;
    }
}

