/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.Http2ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.CancelClientStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.CreateStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBufferAllocator;
import com.google.bigtable.repackaged.io.grpc.netty.RequestMessagesCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendGrpcFrameCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.grpc.netty.WriteQueue;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.buffer.Unpooled;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Stream;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import javax.annotation.Nullable;

abstract class NettyClientStream
extends Http2ClientStream {
    private final MethodDescriptor<?, ?> method;
    private Metadata headers;
    private final Channel channel;
    private final NettyClientHandler handler;
    private AsciiString authority;
    private final AsciiString scheme;
    private Http2Stream http2Stream;
    private Integer id;
    private WriteQueue writeQueue;

    NettyClientStream(MethodDescriptor<?, ?> method, Metadata headers, Channel channel, NettyClientHandler handler, int maxMessageSize, AsciiString authority, AsciiString scheme) {
        super(new NettyWritableBufferAllocator(channel.alloc()), maxMessageSize);
        this.method = Preconditions.checkNotNull(method, "method");
        this.headers = Preconditions.checkNotNull(headers, "headers");
        this.writeQueue = handler.getWriteQueue();
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.handler = Preconditions.checkNotNull(handler, "handler");
        this.authority = Preconditions.checkNotNull(authority, "authority");
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
    }

    @Override
    public void setAuthority(String authority) {
        Preconditions.checkState(this.listener() == null, "must be call before start");
        this.authority = AsciiString.of(Preconditions.checkNotNull(authority, "authority"));
    }

    @Override
    public void start(ClientStreamListener listener) {
        super.start(listener);
        AsciiString defaultPath = new AsciiString("/" + this.method.getFullMethodName());
        Http2Headers http2Headers = Utils.convertClientHeaders(this.headers, this.scheme, defaultPath, this.authority);
        this.headers = null;
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientStream.this.statusFromFailedFuture(future);
                    NettyClientStream.this.transportReportStatus(s, true, new Metadata());
                }
            }
        };
        this.writeQueue.enqueue(new CreateStreamCommand(http2Headers, this), !this.method.getType().clientSendsOneMessage()).addListener(failureListener);
    }

    protected abstract Status statusFromFailedFuture(ChannelFuture var1);

    @Override
    public void request(int numMessages) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.requestMessagesFromDeframer(numMessages);
        } else {
            this.writeQueue.enqueue(new RequestMessagesCommand(this, numMessages), true);
        }
    }

    @Override
    public Integer id() {
        return this.id;
    }

    public void id(int id) {
        this.id = id;
    }

    public void setHttp2Stream(Http2Stream http2Stream) {
        Preconditions.checkNotNull(http2Stream, "http2Stream");
        Preconditions.checkState(this.http2Stream == null, "Can only set http2Stream once");
        this.http2Stream = http2Stream;
        this.onStreamAllocated();
    }

    @Nullable
    public Http2Stream http2Stream() {
        return this.http2Stream;
    }

    void transportHeadersReceived(Http2Headers headers, boolean endOfStream) {
        if (endOfStream) {
            this.transportTrailersReceived(Utils.convertTrailers(headers));
        } else {
            this.transportHeadersReceived(Utils.convertHeaders(headers));
        }
    }

    void transportDataReceived(ByteBuf frame, boolean endOfStream) {
        this.transportDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
    }

    @Override
    protected void sendCancel(Status reason) {
        this.writeQueue.enqueue(new CancelClientStreamCommand(this, reason), true);
    }

    @Override
    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        ByteBuf bytebuf = frame == null ? Unpooled.EMPTY_BUFFER : ((NettyWritableBuffer)frame).bytebuf();
        final int numBytes = bytebuf.readableBytes();
        if (numBytes > 0) {
            this.onSendingBytes(numBytes);
            this.writeQueue.enqueue(new SendGrpcFrameCommand(this, bytebuf, endOfStream), this.channel.newPromise().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyClientStream.this.onSentBytes(numBytes);
                }
            }), flush);
        } else {
            this.writeQueue.enqueue(new SendGrpcFrameCommand(this, bytebuf, endOfStream), flush);
        }
    }

    @Override
    protected void returnProcessedBytes(int processedBytes) {
        this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
        this.writeQueue.scheduleFlush();
    }
}

