/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Ticker;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.Http2Ping;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedClientTransport;
import com.google.bigtable.repackaged.io.grpc.netty.ClientTransportLifecycleManager;
import com.google.bigtable.repackaged.io.grpc.netty.GracefulCloseCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientStream;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.SendPingCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.netty.bootstrap.Bootstrap;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelOption;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;

class NettyClientTransport
implements ManagedClientTransport {
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private ClientTransportLifecycleManager lifecycleManager;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, String authority) {
        this.negotiator = Preconditions.checkNotNull(negotiator, "negotiator");
        this.address = Preconditions.checkNotNull(address, "address");
        this.group = Preconditions.checkNotNull(group, "group");
        this.channelType = Preconditions.checkNotNull(channelType, "channelType");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.authority = new AsciiString(authority);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed(callback, executor, s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener(failureListener);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(headers, "headers");
        return new NettyClientStream(method, headers, this.channel, this.handler, this.maxMessageSize, this.authority, this.negotiationHandler.scheme()){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        };
    }

    @Override
    public void start(ManagedClientTransport.Listener transportListener) {
        this.lifecycleManager = new ClientTransportLifecycleManager(Preconditions.checkNotNull(transportListener, "listener"));
        this.handler = this.newHandler();
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, true);
        }
        b.handler(this.negotiationHandler);
        this.channel = b.connect(this.address).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = future.channel().pipeline().context(NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    future.channel().pipeline().fireExceptionCaught(future.cause());
                }
            }
        }).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NettyClientTransport.this.lifecycleManager.notifyTerminated(Status.INTERNAL.withDescription("Connection closed with unknown cause"));
            }
        });
    }

    @Override
    public void shutdown() {
        if (this.channel.isOpen()) {
            Status status = Status.UNAVAILABLE.withDescription("Channel requested transport to shut down");
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(status), true);
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.address + ")";
    }

    @Override
    public String getLogId() {
        return GrpcUtil.getLogId(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException) {
            NettyClientTransport nettyClientTransport = this;
            synchronized (nettyClientTransport) {
                Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
                if (shutdownStatus == null) {
                    return Status.UNKNOWN.withDescription("Channel closed but for unknown reason");
                }
                return shutdownStatus;
            }
        }
        return Utils.statusFromThrowable(t);
    }

    private NettyClientHandler newHandler() {
        return NettyClientHandler.newHandler(this.lifecycleManager, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker());
    }
}

