/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractServerImplBuilder;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServer;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiators;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.ServerChannel;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class NettyServerBuilder
extends AbstractServerImplBuilder<NettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private final SocketAddress address;
    private Class<? extends ServerChannel> channelType = NioServerSocketChannel.class;
    @Nullable
    private EventLoopGroup bossEventLoopGroup;
    @Nullable
    private EventLoopGroup workerEventLoopGroup;
    private SslContext sslContext;
    private ProtocolNegotiator protocolNegotiator;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x6400000;
    private int maxHeaderListSize = 8192;

    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    public static NettyServerBuilder forRegistryAndPort(HandlerRegistry registry, int port) {
        return new NettyServerBuilder(registry, port);
    }

    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    private NettyServerBuilder(int port) {
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(HandlerRegistry registry, int port) {
        super(registry);
        this.address = new InetSocketAddress(port);
    }

    private NettyServerBuilder(SocketAddress address) {
        this.address = address;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        this.channelType = Preconditions.checkNotNull(channelType);
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        this.bossEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        this.workerEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        Preconditions.checkArgument(sslContext == null || sslContext.isServer(), "Client SSL context can not be used for server");
        this.sslContext = sslContext;
        return this;
    }

    public final NettyServerBuilder protocolNegotiator(@Nullable ProtocolNegotiator protocolNegotiator) {
        this.protocolNegotiator = protocolNegotiator;
        return this;
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument(maxCalls > 0, "max must be positive: %s", maxCalls);
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public NettyServerBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument(maxMessageSize >= 0, "maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public NettyServerBuilder maxHeaderListSize(int maxHeaderListSize) {
        Preconditions.checkArgument(maxHeaderListSize > 0, "maxHeaderListSize must be > 0");
        this.maxHeaderListSize = maxHeaderListSize;
        return this;
    }

    @Override
    protected NettyServer buildTransportServer() {
        ProtocolNegotiator negotiator = this.protocolNegotiator;
        if (negotiator == null) {
            negotiator = this.sslContext != null ? ProtocolNegotiators.serverTls(this.sslContext) : ProtocolNegotiators.serverPlaintext();
        }
        return new NettyServer(this.address, this.channelType, this.bossEventLoopGroup, this.workerEventLoopGroup, negotiator, this.maxConcurrentCallsPerConnection, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize);
    }

    @Override
    public NettyServerBuilder useTransportSecurity(File certChain, File privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

