/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractServerStream;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.CancelServerStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBufferAllocator;
import com.google.bigtable.repackaged.io.grpc.netty.RequestMessagesCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendGrpcFrameCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendResponseHeadersCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.grpc.netty.WriteQueue;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Stream;
import javax.net.ssl.SSLSession;

class NettyServerStream
extends AbstractServerStream<Integer> {
    private final Channel channel;
    private final NettyServerHandler handler;
    private final Http2Stream http2Stream;
    private final WriteQueue writeQueue;
    private final Attributes attributes;

    NettyServerStream(Channel channel, Http2Stream http2Stream, NettyServerHandler handler, int maxMessageSize) {
        super(new NettyWritableBufferAllocator(channel.alloc()), maxMessageSize);
        this.writeQueue = handler.getWriteQueue();
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.http2Stream = Preconditions.checkNotNull(http2Stream, "http2Stream");
        this.handler = Preconditions.checkNotNull(handler, "handler");
        this.attributes = NettyServerStream.buildAttributes(channel);
    }

    @Override
    public Integer id() {
        return this.http2Stream.id();
    }

    @Override
    protected void inboundHeadersReceived(Metadata headers) {
        super.inboundHeadersReceived(headers);
    }

    void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
        super.inboundDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
    }

    @Override
    public void request(int numMessages) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.requestMessagesFromDeframer(numMessages);
        } else {
            this.writeQueue.enqueue(new RequestMessagesCommand(this, numMessages), true);
        }
    }

    @Override
    protected void inboundDeliveryPaused() {
    }

    @Override
    protected void internalSendHeaders(Metadata headers) {
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), Utils.convertServerHeaders(headers), false), true);
    }

    @Override
    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
        final int numBytes = bytebuf.readableBytes();
        this.onSendingBytes(numBytes);
        this.writeQueue.enqueue(new SendGrpcFrameCommand(this, bytebuf, endOfStream), this.channel.newPromise().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerStream.this.onSentBytes(numBytes);
            }
        }), flush);
    }

    @Override
    protected void sendTrailers(Metadata trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
        this.writeQueue.enqueue(new SendResponseHeadersCommand(this.id(), http2Trailers, true), true);
    }

    @Override
    protected void returnProcessedBytes(int processedBytes) {
        this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
        this.writeQueue.scheduleFlush();
    }

    @Override
    protected void sendStreamAbortToClient(Status status, Metadata trailers) {
        this.cancel(status);
    }

    @Override
    public void cancel(Status status) {
        this.writeQueue.enqueue(new CancelServerStreamCommand(this, status), true);
    }

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    private static Attributes buildAttributes(Channel channel) {
        SSLSession sslSession = null;
        if (channel.hasAttr(Utils.SSL_SESSION_ATTR_KEY)) {
            sslSession = channel.attr(Utils.SSL_SESSION_ATTR_KEY).get();
        }
        return Attributes.newBuilder().set(ServerCall.REMOTE_ADDR_KEY, channel.remoteAddress()).set(ServerCall.SSL_SESSION_KEY, sslSession).build();
    }
}

