/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import com.google.bigtable.repackaged.io.grpc.internal.TransportFrameUtil;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.nio.NioEventLoopGroup;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Exception;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import com.google.bigtable.repackaged.io.netty.util.AttributeKey;
import com.google.bigtable.repackaged.io.netty.util.CharsetUtil;
import com.google.bigtable.repackaged.io.netty.util.concurrent.DefaultThreadFactory;
import com.google.bigtable.repackaged.io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

class Utils {
    public static final AsciiString STATUS_OK = AsciiString.of("200");
    public static final AsciiString HTTP_METHOD = AsciiString.of("POST");
    public static final AsciiString HTTPS = AsciiString.of("https");
    public static final AsciiString HTTP = AsciiString.of("http");
    public static final AsciiString CONTENT_TYPE_HEADER = AsciiString.of(GrpcUtil.CONTENT_TYPE_KEY.name());
    public static final AsciiString CONTENT_TYPE_GRPC = AsciiString.of("application/grpc");
    public static final AsciiString TE_HEADER = AsciiString.of("te");
    public static final AsciiString TE_TRAILERS = AsciiString.of("trailers");
    public static final AsciiString USER_AGENT = AsciiString.of(GrpcUtil.USER_AGENT_KEY.name());
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG");
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG");
    public static final AttributeKey<SSLSession> SSL_SESSION_ATTR_KEY = AttributeKey.valueOf(SSLSession.class, "ssl-session");

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            headerValues[i++] = Utils.bytes(entry.getKey());
            headerValues[i++] = Utils.bytes(entry.getValue());
        }
        return TransportFrameUtil.toRawSerializedHeaders(headerValues);
    }

    private static byte[] bytes(CharSequence seq) {
        if (seq instanceof AsciiString) {
            return ((AsciiString)seq).array();
        }
        return seq.toString().getBytes(CharsetUtil.UTF_8);
    }

    public static Http2Headers convertClientHeaders(Metadata headers, AsciiString scheme, AsciiString defaultPath, AsciiString authority) {
        Preconditions.checkNotNull(defaultPath, "defaultPath");
        Preconditions.checkNotNull(authority, "authority");
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        ((Http2Headers)http2Headers.authority(authority).path(defaultPath).method(HTTP_METHOD).scheme(scheme).set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC)).set(TE_HEADER, TE_TRAILERS);
        String userAgent = GrpcUtil.getGrpcUserAgent("netty", headers.get(GrpcUtil.USER_AGENT_KEY));
        http2Headers.set(USER_AGENT, new AsciiString(userAgent.getBytes(CharsetUtil.UTF_8)));
        return http2Headers;
    }

    public static Http2Headers convertServerHeaders(Metadata headers) {
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        http2Headers.set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC);
        http2Headers.status(STATUS_OK);
        return http2Headers;
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Http2Headers convertTrailers(Metadata trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertMetadata(trailers);
        if (!headersSent) {
            http2Trailers.set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC);
            http2Trailers.status(STATUS_OK);
        }
        return http2Trailers;
    }

    private static Http2Headers convertMetadata(Metadata headers) {
        Preconditions.checkNotNull(headers, "headers");
        boolean validate = true;
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(validate, headers.headerCount());
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers(headers);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            AsciiString name = new AsciiString(serializedHeaders[i], false);
            AsciiString value = new AsciiString(serializedHeaders[i + 1], false);
            http2Headers.add(name, value);
        }
        return http2Headers;
    }

    public static Status statusFromThrowable(Throwable t) {
        Status s = Status.fromThrowable(t);
        if (s.getCode() != Status.Code.UNKNOWN) {
            return s;
        }
        if (t instanceof IOException) {
            return Status.UNAVAILABLE.withCause(t);
        }
        if (t instanceof Http2Exception) {
            return Status.INTERNAL.withCause(t);
        }
        return s;
    }

    private Utils() {
    }

    private static class ThreadGroupSavingDefaultThreadFactory
    extends DefaultThreadFactory {
        final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();

        ThreadGroupSavingDefaultThreadFactory(String name, boolean daemon) {
            super(name, daemon);
        }

        @Override
        protected Thread newThread(Runnable r, String name) {
            return new FastThreadLocalThread(this.threadGroup, r, name);
        }
    }

    private static class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;

        DefaultEventLoopGroupResource(int numEventLoops, String name) {
            this.name = name;
            this.numEventLoops = numEventLoops;
        }

        @Override
        public EventLoopGroup create() {
            boolean useDaemonThreads = true;
            ThreadGroupSavingDefaultThreadFactory threadFactory = new ThreadGroupSavingDefaultThreadFactory(this.name, useDaemonThreads);
            int parallelism = this.numEventLoops == 0 ? Runtime.getRuntime().availableProcessors() * 2 : this.numEventLoops;
            return new NioEventLoopGroup(parallelism, threadFactory);
        }

        @Override
        public void close(EventLoopGroup instance) {
            instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public String toString() {
            return this.name;
        }
    }
}

