/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.protobuf;

import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.Message;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.bigtable.repackaged.com.google.protobuf.util.JsonFormat;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.protobuf.lite.ProtoLiteUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class ProtoUtils {
    @Deprecated
    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        return ProtoLiteUtils.marshaller(defaultInstance);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        return ProtoLiteUtils.marshaller(defaultInstance);
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(final T defaultInstance) {
        final JsonFormat.Printer printer = JsonFormat.printer();
        final JsonFormat.Parser parser = JsonFormat.parser();
        final Charset charset = Charset.forName("UTF-8");
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                try {
                    return new ByteArrayInputStream(printer.print((MessageOrBuilder)value).getBytes(charset));
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INVALID_ARGUMENT.withCause(e).withDescription("Unable to print json proto").asRuntimeException();
                }
            }

            @Override
            public T parse(InputStream stream) {
                Message proto;
                Message.Builder builder = defaultInstance.newBuilderForType();
                InputStreamReader reader = new InputStreamReader(stream, charset);
                try {
                    parser.merge(reader, builder);
                    proto = builder.build();
                    ((Reader)reader).close();
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(e).asRuntimeException();
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(e).asRuntimeException();
                }
                return proto;
            }
        };
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(T instance) {
        return Metadata.Key.of(instance.getDescriptorForType().getFullName() + "-bin", ProtoLiteUtils.metadataMarshaller(instance));
    }

    private ProtoUtils() {
    }
}

