/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.protobuf.lite;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.CodedInputStream;
import com.google.bigtable.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.repackaged.com.google.protobuf.Parser;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.protobuf.lite.ProtoInputStream;
import java.io.InputStream;

public class ProtoLiteUtils {
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();

    public static void setExtensionRegistry(ExtensionRegistryLite newRegistry) {
        globalRegistry = Preconditions.checkNotNull(newRegistry, "newRegistry");
    }

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        final Parser<? extends MessageLite> parser = defaultInstance.getParserForType();
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, parser);
            }

            @Override
            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    try {
                        MessageLite message = ((ProtoInputStream)stream).message();
                        return message;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                try {
                    return this.parseFrom(stream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(ipbe).asRuntimeException();
                }
            }

            private T parseFrom(InputStream stream) throws InvalidProtocolBufferException {
                CodedInputStream codedInput = CodedInputStream.newInstance(stream);
                codedInput.setSizeLimit(Integer.MAX_VALUE);
                MessageLite message = (MessageLite)parser.parseFrom(codedInput, globalRegistry);
                try {
                    codedInput.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends MessageLite> Metadata.BinaryMarshaller<T> metadataMarshaller(final T instance) {
        return new Metadata.BinaryMarshaller<T>(){

            @Override
            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            @Override
            public T parseBytes(byte[] serialized) {
                try {
                    return instance.getParserForType().parseFrom(serialized, globalRegistry);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        };
    }

    private ProtoLiteUtils() {
    }
}

