/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.handler.codec.http2;

import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBufOutputStream;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Error;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Exception;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2HeaderTable;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2HeadersEncoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.internal.hpack.Encoder;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import com.google.bigtable.repackaged.io.netty.util.internal.ObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder.Configuration {
    private final Encoder encoder;
    private final ByteArrayOutputStream tableSizeChangeOutput = new ByteArrayOutputStream();
    private final Http2HeadersEncoder.SensitivityDetector sensitivityDetector;
    private final Http2HeaderTable headerTable;

    public DefaultHttp2HeadersEncoder() {
        this(4096, NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(int maxHeaderTableSize, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(sensitivityDetector, "sensitiveDetector");
        this.encoder = new Encoder(maxHeaderTableSize);
        this.headerTable = new Http2HeaderTableEncoder();
    }

    @Override
    public void encodeHeaders(Http2Headers headers, ByteBuf buffer) throws Http2Exception {
        ByteBufOutputStream stream = new ByteBufOutputStream(buffer);
        try {
            if (headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", headers.size(), this.headerTable.maxHeaderListSize());
            }
            if (this.tableSizeChangeOutput.size() > 0) {
                buffer.writeBytes(this.tableSizeChangeOutput.toByteArray());
                this.tableSizeChangeOutput.reset();
            }
            for (Map.Entry<CharSequence, CharSequence> header : headers) {
                this.encodeHeader(header.getKey(), header.getValue(), stream);
            }
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, t, "Failed encoding headers block: %s", t.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, e, e.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public Http2HeadersEncoder.Configuration configuration() {
        return this;
    }

    private byte[] toBytes(CharSequence chars) {
        AsciiString aString = AsciiString.of(chars);
        return aString.isEntireArrayUsed() ? aString.array() : aString.toByteArray();
    }

    private void encodeHeader(CharSequence key, CharSequence value, OutputStream stream) throws IOException {
        this.encoder.encodeHeader(stream, this.toBytes(key), this.toBytes(value), this.sensitivityDetector.isSensitive(key, value));
    }

    private final class Http2HeaderTableEncoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableEncoder() {
        }

        @Override
        public void maxHeaderTableSize(int max) throws Http2Exception {
            if (max < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", max);
            }
            try {
                DefaultHttp2HeadersEncoder.this.encoder.setMaxHeaderTableSize(DefaultHttp2HeadersEncoder.this.tableSizeChangeOutput, max);
            }
            catch (IOException e) {
                throw new Http2Exception(Http2Error.COMPRESSION_ERROR, e.getMessage(), e);
            }
            catch (Throwable t) {
                throw new Http2Exception(Http2Error.PROTOCOL_ERROR, t.getMessage(), t);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersEncoder.this.encoder.getMaxHeaderTableSize();
        }
    }
}

