/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.handler.ssl;

import com.google.bigtable.repackaged.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.google.bigtable.repackaged.io.netty.handler.ssl.CipherSuiteFilter;
import com.google.bigtable.repackaged.io.netty.handler.ssl.ClientAuth;
import com.google.bigtable.repackaged.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSsl;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSslContext;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSslEngine;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSslSessionContext;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslClientContext
extends OpenSslContext {
    private final OpenSslSessionContext sessionContext;

    @Deprecated
    public OpenSslClientContext() throws SSLException {
        this((File)null, null, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile) throws SSLException {
        this(certChainFile, null);
    }

    @Deprecated
    public OpenSslClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        this(null, trustManagerFactory);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, ciphers, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, apn, sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslClientContext(File trustCertCollectionFile, TrustManagerFactory trustManagerFactory, File keyCertChainFile, File keyFile, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(OpenSslClientContext.toX509CertificatesInternal(trustCertCollectionFile), trustManagerFactory, OpenSslClientContext.toX509CertificatesInternal(keyCertChainFile), OpenSslClientContext.toPrivateKeyInternal(keyFile, keyPassword), keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslClientContext(X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        super(ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, 0, (Certificate[])keyCertChain, ClientAuth.NONE);
        boolean success = false;
        try {
            OpenSslClientContext.checkKeyManagerFactory(keyManagerFactory);
            if (key == null && keyCertChain != null || key != null && keyCertChain == null) {
                throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
            }
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                if (keyCertChain != null && key != null) {
                    long keyBio = 0L;
                    long keyCertChainBio = 0L;
                    try {
                        long error;
                        keyCertChainBio = OpenSslClientContext.toBIO(keyCertChain);
                        keyBio = OpenSslClientContext.toBIO(key);
                        if (!SSLContext.setCertificateBio((long)this.ctx, (long)keyCertChainBio, (long)keyBio, (String)keyPassword, (int)0) && OpenSsl.isError(error = (long)SSL.getLastErrorNumber())) {
                            throw new SSLException("failed to set certificate and key: " + SSL.getErrorString((long)error));
                        }
                        if (!SSLContext.setCertificateChainBio((long)this.ctx, (long)keyCertChainBio, (boolean)false) && OpenSsl.isError(error = (long)SSL.getLastErrorNumber())) {
                            throw new SSLException("failed to set certificate chain: " + SSL.getErrorString((long)error));
                        }
                    }
                    catch (SSLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SSLException("failed to set certificate and key", e);
                    }
                    finally {
                        if (keyBio != 0L) {
                            SSL.freeBIO((long)keyBio);
                        }
                        if (keyCertChainBio != 0L) {
                            SSL.freeBIO((long)keyCertChainBio);
                        }
                    }
                }
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                try {
                    if (trustCertCollection != null) {
                        trustManagerFactory = OpenSslClientContext.buildTrustManagerFactory(trustCertCollection, trustManagerFactory);
                    } else if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    }
                    final X509TrustManager manager = OpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    if (OpenSslClientContext.useExtendedTrustManager(manager)) {
                        final X509ExtendedTrustManager extendedManager = (X509ExtendedTrustManager)manager;
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new OpenSslContext.AbstractCertificateVerifier(){

                            @Override
                            void verify(OpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
                                extendedManager.checkServerTrusted(peerCerts, auth, engine);
                            }
                        });
                    } else {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new OpenSslContext.AbstractCertificateVerifier(){

                            @Override
                            void verify(OpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
                                manager.checkServerTrusted(peerCerts, auth);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    throw new SSLException("unable to setup trustmanager", e);
                }
                this.sessionContext = new OpenSslClientSessionContext(this.ctx);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    private static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        private OpenSslClientSessionContext(long context) {
            super(context);
        }

        @Override
        public void setSessionTimeout(int seconds) {
            if (seconds < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionTimeout() {
            return 0;
        }

        @Override
        public void setSessionCacheSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionCacheSize() {
            return 0;
        }

        @Override
        public void setSessionCacheEnabled(boolean enabled) {
        }

        @Override
        public boolean isSessionCacheEnabled() {
            return false;
        }
    }
}

