/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.netty.resolver;

import com.google.bigtable.repackaged.io.netty.resolver.InetNameResolver;
import com.google.bigtable.repackaged.io.netty.util.concurrent.EventExecutor;
import com.google.bigtable.repackaged.io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor executor) {
        super(executor);
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess(InetAddress.getByName(inetHost));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(Arrays.asList(InetAddress.getAllByName(inetHost)));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }
}

