/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow;

import com.google.cloud.bigtable.dataflow.CloudBigtableConfiguration;
import com.google.cloud.bigtable.dataflow.CloudBigtableConnectionPool;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCloudBigtableTableDoFn<In, Out>
extends DoFn<In, Out> {
    private static final long serialVersionUID = 1L;
    static final CloudBigtableConnectionPool pool = new CloudBigtableConnectionPool();
    protected final Logger DOFN_LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final CloudBigtableConfiguration config;
    protected Connection connection;

    public static void logRetriesExhaustedWithDetailsException(Logger log, String context, RetriesExhaustedWithDetailsException exception) {
        if (log.isDebugEnabled()) {
            log.error("For context {}: exception occured during a bulk operation: {}", (Object)context, (Object)exception.getExhaustiveDescription());
        }
        if (exception.getNumExceptions() == 0) {
            log.error("For context {}: Got a RetriesExhaustedWithDetailsException without any details.", (Throwable)exception);
            return;
        }
        TreeMap<String, Integer> furtherInfo = new TreeMap<String, Integer>();
        List causes = exception.getCauses();
        for (Throwable throwable : causes) {
            String message = throwable.getMessage();
            Integer count = (Integer)furtherInfo.get(message);
            if (count == null) {
                furtherInfo.put(message, 1);
                continue;
            }
            furtherInfo.put(message, 1 + count);
        }
        log.error(String.format("For context %s: %d exceptions occured during a bulk operation:\n\t%s.\nThe stack trace is a sample exception, of the first exception.\nBreakdown of exceptions {type - count}: %s", context, exception.getNumExceptions(), exception.getMessage(), furtherInfo), exception.getCause(0));
    }

    protected static void rethrowException(RetriesExhaustedWithDetailsException exception) throws Exception {
        if (exception.getCauses().size() == 1) {
            throw (Exception)exception.getCause(0);
        }
        throw exception;
    }

    public AbstractCloudBigtableTableDoFn(CloudBigtableConfiguration config) {
        this.config = config;
    }

    protected synchronized Connection getConnection() throws IOException {
        if (this.connection == null) {
            this.connection = pool.getConnection(this.config.toHBaseConfig());
        }
        return this.connection;
    }

    protected void logExceptions(DoFn.Context context, RetriesExhaustedWithDetailsException exception) {
        AbstractCloudBigtableTableDoFn.logRetriesExhaustedWithDetailsException(this.DOFN_LOG, context.toString(), exception);
    }
}

