/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;

public class CloudBigtableConfiguration
implements Serializable {
    private static final long serialVersionUID = 1655181275627002133L;
    private Map<String, String> configuration;

    CloudBigtableConfiguration() {
    }

    public CloudBigtableConfiguration(String projectId, String instanceId, Map<String, String> additionalConfiguration) {
        this.configuration = new HashMap<String, String>(additionalConfiguration);
        this.setValue("google.bigtable.project.id", projectId, "Project ID");
        this.setValue("google.bigtable.instance.id", instanceId, "Instance ID");
    }

    private void setValue(String key, String value, String type) {
        Preconditions.checkArgument((!this.configuration.containsKey(key) ? 1 : 0) != 0, (String)"%s was set twice", (Object[])new Object[]{key});
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"%s must be set.", (Object[])new Object[]{type});
        this.configuration.put(key, value);
    }

    public String getProjectId() {
        return this.configuration.get("google.bigtable.project.id");
    }

    public String getInstanceId() {
        return this.configuration.get("google.bigtable.instance.id");
    }

    public BigtableOptions toBigtableOptions() throws IOException {
        return BigtableOptionsFactory.fromConfiguration(this.toHBaseConfig());
    }

    public Configuration toHBaseConfig() {
        Configuration config = new Configuration(false);
        config.set("google.bigtable.buffered.mutator.async.worker.count", "0");
        for (Map.Entry<String, String> entry : this.configuration.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    protected ImmutableMap<String, String> getConfiguration() {
        return ImmutableMap.copyOf(this.configuration);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CloudBigtableConfiguration other = (CloudBigtableConfiguration)obj;
        return Objects.equals(this.configuration, other.configuration);
    }

    public void copyConfig(Builder builder) {
        builder.copyFrom(this.configuration);
    }

    public static class Builder {
        protected String projectId;
        protected String instanceId;
        protected Map<String, String> additionalConfiguration = new HashMap<String, String>();

        protected void copyFrom(Map<String, String> configuration) {
            this.additionalConfiguration.putAll(configuration);
            this.projectId = this.additionalConfiguration.remove("google.bigtable.project.id");
            this.instanceId = this.additionalConfiguration.remove("google.bigtable.instance.id");
        }

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withConfiguration(String key, String value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value cannot be null");
            this.additionalConfiguration.put(key, value);
            return this;
        }

        public CloudBigtableConfiguration build() {
            return new CloudBigtableConfiguration(this.projectId, this.instanceId, this.additionalConfiguration);
        }
    }
}

