/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow;

import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.cloud.bigtable.hbase1_0.BigtableConnection;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudBigtableConnectionPool {
    protected static final Logger LOG = LoggerFactory.getLogger(CloudBigtableConnectionPool.class);
    private final Map<String, Connection> connections = new HashMap<String, Connection>();

    public Connection getConnection(Configuration config) throws IOException {
        String key = BigtableOptionsFactory.fromConfiguration(config).getInstanceName().toString();
        return this.getConnection(config, key);
    }

    protected synchronized Connection getConnection(Configuration config, String key) throws IOException {
        Connection connection = this.connections.get(key);
        if (connection == null) {
            connection = this.createConnection(config);
            this.connections.put(key, connection);
        }
        return connection;
    }

    @VisibleForTesting
    protected Connection createConnection(Configuration config) throws IOException {
        return new BigtableConnection(config){

            @Override
            public void close() throws IOException {
                LOG.info("Calling close() on the connection from dataflow is a noop. Please don't close() the connection yourself.");
            }
        };
    }
}

