/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow;

import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.DefaultReadHooks;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReadHooks;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.dataflow.CloudBigtableOptions;
import com.google.cloud.bigtable.dataflow.CloudBigtableTableConfiguration;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.client.Scan;

public class CloudBigtableScanConfiguration
extends CloudBigtableTableConfiguration {
    private static final long serialVersionUID = 2435897354284600685L;
    private final ReadRowsRequest request;

    public static CloudBigtableScanConfiguration fromCBTOptions(CloudBigtableOptions options) {
        return CloudBigtableScanConfiguration.fromCBTOptions(options, new Scan());
    }

    public static CloudBigtableScanConfiguration fromCBTOptions(CloudBigtableOptions options, Scan scan) {
        Builder builder = new Builder();
        CloudBigtableScanConfiguration.copyOptions(options, builder);
        return builder.withScan(scan).build();
    }

    public static CloudBigtableScanConfiguration fromConfig(CloudBigtableTableConfiguration config, Scan scan) {
        Builder builder = new Builder();
        config.copyConfig(builder);
        return builder.withScan(scan).build();
    }

    protected CloudBigtableScanConfiguration(String projectId, String instanceId, String tableId, ReadRowsRequest request, Map<String, String> additionalConfiguration) {
        super(projectId, instanceId, tableId, additionalConfiguration);
        this.request = request;
    }

    public ReadRowsRequest getRequest() {
        return this.request;
    }

    public byte[] getStartRow() {
        return this.request.getRows().getRowRanges(0).getStartKeyClosed().toByteArray();
    }

    public byte[] getStopRow() {
        return this.request.getRows().getRowRanges(0).getEndKeyOpen().toByteArray();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.request, ((CloudBigtableScanConfiguration)obj).request);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    public void copyConfig(Builder builder) {
        super.copyConfig(builder);
        builder.withRequest(this.request);
    }

    public static class Builder
    extends CloudBigtableTableConfiguration.Builder {
        protected Scan scan = new Scan();
        private ReadRowsRequest request;

        public Builder withScan(Scan scan) {
            this.scan = scan;
            this.request = null;
            return this;
        }

        public Builder withRequest(ReadRowsRequest request) {
            this.request = request;
            this.scan = null;
            return this;
        }

        @Override
        public Builder withProjectId(String projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withInstanceId(String instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, String value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public Builder withTableId(String tableId) {
            super.withTableId(tableId);
            return this;
        }

        @Override
        public CloudBigtableScanConfiguration build() {
            if (this.request == null) {
                DefaultReadHooks readHooks = new DefaultReadHooks();
                ReadRowsRequest.Builder builder = Adapters.SCAN_ADAPTER.adapt(this.scan, (ReadHooks)readHooks);
                builder.setTableName(new BigtableInstanceName(this.projectId, this.instanceId).toTableNameStr(this.tableId));
                this.request = readHooks.applyPreSendHook(builder.build());
            }
            return new CloudBigtableScanConfiguration(this.projectId, this.instanceId, this.tableId, this.request, this.additionalConfiguration);
        }
    }
}

