/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.dataflow;

import com.google.cloud.bigtable.dataflow.CloudBigtableConfiguration;
import com.google.cloud.bigtable.dataflow.CloudBigtableOptions;
import java.util.Map;
import java.util.Objects;

public class CloudBigtableTableConfiguration
extends CloudBigtableConfiguration {
    private static final long serialVersionUID = 2435897354284600685L;
    protected String tableId;

    public static CloudBigtableTableConfiguration fromCBTOptions(CloudBigtableOptions options) {
        Builder builder = new Builder();
        CloudBigtableTableConfiguration.copyOptions(options, builder);
        return builder.build();
    }

    protected static void copyOptions(CloudBigtableOptions options, Builder builder) {
        builder.withProjectId(options.getBigtableProjectId()).withInstanceId(options.getBigtableInstanceId()).withTableId(options.getBigtableTableId());
    }

    CloudBigtableTableConfiguration() {
    }

    public CloudBigtableTableConfiguration(String projectId, String instanceId, String tableId, Map<String, String> additionalConfiguration) {
        super(projectId, instanceId, additionalConfiguration);
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        this.copyConfig(builder);
        return builder;
    }

    public void copyConfig(Builder builder) {
        super.copyConfig(builder);
        builder.tableId = this.tableId;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.tableId, ((CloudBigtableTableConfiguration)obj).tableId);
    }

    public static class Builder
    extends CloudBigtableConfiguration.Builder {
        protected String tableId;

        public Builder withTableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public Builder withProjectId(String projectId) {
            super.withProjectId(projectId);
            return this;
        }

        @Override
        public Builder withInstanceId(String instanceId) {
            super.withInstanceId(instanceId);
            return this;
        }

        @Override
        public Builder withConfiguration(String key, String value) {
            super.withConfiguration(key, value);
            return this;
        }

        @Override
        public CloudBigtableTableConfiguration build() {
            return new CloudBigtableTableConfiguration(this.projectId, this.instanceId, this.tableId, this.additionalConfiguration);
        }
    }
}

